/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.monitoring.clients.interceptor;

import io.confluent.monitoring.clients.interceptor.MonitoringMetrics;
import io.confluent.monitoring.clients.interceptor.TimeBuckets;
import io.confluent.shaded.com.google.common.collect.EvictingQueue;
import io.confluent.shaded.monitoring.record.Monitoring;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

public class MonitoringTimeBuckets
extends TimeBuckets<MonitoringMetrics> {
    public static final long UNKNOWN_WINDOW = -1L;
    private final AtomicLong curSequenceNumber = new AtomicLong(0L);
    private TimeWindowHistory windowHistory;

    public MonitoringTimeBuckets(long bucketSizeMs, int windowHistorySize) {
        super(bucketSizeMs);
        this.windowHistory = new TimeWindowHistory(windowHistorySize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(long messageTimestamp, int size, long checksum, long latency) {
        MonitoringTimeBuckets monitoringTimeBuckets = this;
        synchronized (monitoringTimeBuckets) {
            TimeBuckets.Bucket bucket = this.get(messageTimestamp);
            if (bucket.data == null) {
                bucket.data = new MonitoringMetrics();
            }
            ((MonitoringMetrics)bucket.data).recordMessageEvent(size, checksum, latency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitoring.MonitoringMessage.Builder getNextMetrics(Monitoring.MonitoringMessage base, long now) {
        Monitoring.MonitoringMessage.Builder monitoringMessageBuilder = null;
        MonitoringTimeBuckets monitoringTimeBuckets = this;
        synchronized (monitoringTimeBuckets) {
            TimeBuckets.Bucket bucket = this.removeOldestBucket();
            if (bucket != null) {
                monitoringMessageBuilder = Monitoring.MonitoringMessage.newBuilder(base);
                monitoringMessageBuilder.setSequence(this.curSequenceNumber.getAndIncrement());
                monitoringMessageBuilder.setWindow(bucket.timestamp);
                monitoringMessageBuilder.setSamplePeriod(this.getBucketSizeMs());
                monitoringMessageBuilder.setTimestamp(now);
                monitoringMessageBuilder.setType(Monitoring.MessageType.NORMAL);
                this.windowHistory.fillMinMaxWindowsAndRecord(monitoringMessageBuilder);
                ((MonitoringMetrics)bucket.data).fillMonitoringMessage(monitoringMessageBuilder);
            }
        }
        return monitoringMessageBuilder;
    }

    public Monitoring.MonitoringMessage.Builder getEmptyMetrics(Monitoring.MonitoringMessage base, long now) {
        Monitoring.MonitoringMessage.Builder monitoringMessageBuilder = Monitoring.MonitoringMessage.newBuilder(base);
        monitoringMessageBuilder.setTimestamp(now);
        monitoringMessageBuilder.setSequence(this.curSequenceNumber.getAndIncrement());
        monitoringMessageBuilder.setSamplePeriod(this.getBucketSizeMs());
        this.windowHistory.fillMinMaxWindowsAndRecord(monitoringMessageBuilder);
        monitoringMessageBuilder.setWindow(0L);
        monitoringMessageBuilder.setType(Monitoring.MessageType.HEARTBEAT);
        MonitoringMetrics metrics = new MonitoringMetrics();
        metrics.fillMonitoringMessage(monitoringMessageBuilder);
        return monitoringMessageBuilder;
    }

    public void resetSequence() {
        this.curSequenceNumber.set(0L);
    }

    private static class TimeWindowHistory {
        Queue<Long> history;

        public TimeWindowHistory(int size) {
            this.history = EvictingQueue.create(size);
        }

        public void fillMinMaxWindowsAndRecord(Monitoring.MonitoringMessage.Builder monitoringMessage) {
            for (Long window : this.history) {
                if (window == -1L) continue;
                monitoringMessage.setMinWindow(Math.min(window, TimeWindowHistory.defaultIfUnknown(monitoringMessage.getMinWindow(), window)));
                monitoringMessage.setMaxWindow(Math.max(window, TimeWindowHistory.defaultIfUnknown(monitoringMessage.getMaxWindow(), window)));
            }
            this.history.add(monitoringMessage.getWindow() == -1L ? -1L : monitoringMessage.getWindow());
        }

        private static long defaultIfUnknown(long maybeUnknown, long defaultValue) {
            return maybeUnknown == -1L ? defaultValue : maybeUnknown;
        }
    }
}

