/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.tracked;

import io.confluent.ksql.serde.tracked.TrackedCallback;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

final class TrackedDeserializer<T>
implements Deserializer<T> {
    private final Deserializer<T> inner;
    private final TrackedCallback callback;
    private Boolean key;

    TrackedDeserializer(Deserializer<T> inner, TrackedCallback callback) {
        this.inner = Objects.requireNonNull(inner, "inner");
        this.callback = Objects.requireNonNull(callback, "callback");
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner.configure(configs, isKey);
        this.key = isKey;
    }

    public T deserialize(String topic, byte[] data) {
        this.track(topic);
        return (T)this.inner.deserialize(topic, data);
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        this.track(topic);
        return (T)this.inner.deserialize(topic, headers, data);
    }

    public void close() {
        this.inner.close();
    }

    private void track(String topicName) {
        if (this.key == null) {
            throw new IllegalStateException("Configure not called");
        }
        this.callback.accept(topicName, this.key);
    }
}

