/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.SerializationError;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.serialization.Serializer;

public final class LoggingSerializer<T>
implements Serializer<T> {
    private final Serializer<T> delegate;
    private final ProcessingLogger processingLogger;
    private boolean isKey;

    public LoggingSerializer(Serializer<T> delegate, ProcessingLogger processingLogger) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.processingLogger = Objects.requireNonNull(processingLogger, "processingLogger");
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.delegate.configure(configs, isKey);
    }

    public byte[] serialize(String topic, T data) {
        try {
            return this.delegate.serialize(topic, data);
        }
        catch (RuntimeException e) {
            this.processingLogger.error(new SerializationError<T>(e, Optional.of(data), topic, this.isKey));
            throw e;
        }
    }

    public void close() {
        this.delegate.close();
    }
}

