/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSubTypes(value={})
public final class StreamedRow {
    private static final ObjectMapper OBJECT_MAPPER = ApiJsonMapper.INSTANCE.get();
    private final Optional<Header> header;
    private final Optional<DataRow> row;
    private final Optional<KsqlErrorMessage> errorMessage;
    private final Optional<String> finalMessage;
    private final Optional<KsqlHostInfoEntity> sourceHost;

    public static StreamedRow header(QueryId queryId, LogicalSchema schema) {
        return new StreamedRow(Optional.of(Header.of(queryId, schema)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow pushRow(GenericRow value) {
        return new StreamedRow(Optional.empty(), Optional.of(DataRow.row(value.values())), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow pullRow(GenericRow value, Optional<KsqlHostInfoEntity> sourceHost) {
        return new StreamedRow(Optional.empty(), Optional.of(DataRow.row(value.values())), Optional.empty(), Optional.empty(), sourceHost);
    }

    public static StreamedRow tombstone(GenericRow columns) {
        return new StreamedRow(Optional.empty(), Optional.of(DataRow.tombstone(columns.values())), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow error(Throwable exception, int errorCode) {
        return new StreamedRow(Optional.empty(), Optional.empty(), Optional.of(new KsqlErrorMessage(errorCode, exception)), Optional.empty(), Optional.empty());
    }

    public static StreamedRow finalMessage(String finalMessage) {
        return new StreamedRow(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(finalMessage), Optional.empty());
    }

    @JsonCreator
    private StreamedRow(@JsonProperty(value="header") Optional<Header> header, @JsonProperty(value="row") Optional<DataRow> row, @JsonProperty(value="errorMessage") Optional<KsqlErrorMessage> errorMessage, @JsonProperty(value="finalMessage") Optional<String> finalMessage, @JsonProperty(value="sourceHost") Optional<KsqlHostInfoEntity> sourceHost) {
        this.header = Objects.requireNonNull(header, "header");
        this.row = Objects.requireNonNull(row, "row");
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage");
        this.finalMessage = Objects.requireNonNull(finalMessage, "finalMessage");
        this.sourceHost = Objects.requireNonNull(sourceHost, "sourceHost");
        StreamedRow.checkUnion(header, row, errorMessage, finalMessage);
    }

    public Optional<Header> getHeader() {
        return this.header;
    }

    public Optional<DataRow> getRow() {
        return this.row;
    }

    public Optional<KsqlErrorMessage> getErrorMessage() {
        return this.errorMessage;
    }

    public Optional<String> getFinalMessage() {
        return this.finalMessage;
    }

    public Optional<KsqlHostInfoEntity> getSourceHost() {
        return this.sourceHost;
    }

    @JsonIgnore
    public boolean isTerminal() {
        return this.finalMessage.isPresent() || this.errorMessage.isPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamedRow that = (StreamedRow)o;
        return Objects.equals(this.header, that.header) && Objects.equals(this.row, that.row) && Objects.equals(this.errorMessage, that.errorMessage) && Objects.equals(this.finalMessage, that.finalMessage) && Objects.equals(this.sourceHost, that.sourceHost);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.row, this.errorMessage, this.finalMessage, this.sourceHost);
    }

    public String toString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return super.toString();
        }
    }

    private static void checkUnion(Optional<?> ... fs) {
        long count = Arrays.stream(fs).filter(Optional::isPresent).count();
        if (count != 1L) {
            throw new IllegalArgumentException("Exactly one parameter should be non-null. got: " + count);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class DataRow
    extends BaseRow {
        @EffectivelyImmutable
        private final List<?> columns;
        private final boolean tombstone;

        public static DataRow row(List<?> columns) {
            return new DataRow(columns, Optional.empty());
        }

        public static DataRow tombstone(List<?> columns) {
            return new DataRow(columns, Optional.of(true));
        }

        public List<?> getColumns() {
            return this.columns;
        }

        public Optional<Boolean> getTombstone() {
            return this.tombstone ? Optional.of(true) : Optional.empty();
        }

        @JsonCreator
        private DataRow(@JsonProperty(value="columns") List<?> columns, @JsonProperty(value="tombstone") Optional<Boolean> tombstone) {
            this.tombstone = tombstone.orElse(false);
            this.columns = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(columns, "columns")));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataRow row = (DataRow)o;
            return this.tombstone == row.tombstone && Objects.equals(this.columns, row.columns);
        }

        public int hashCode() {
            return Objects.hash(this.tombstone, this.columns);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Header
    extends BaseRow {
        private final QueryId queryId;
        private final LogicalSchema columnsSchema;

        public static Header of(QueryId queryId, LogicalSchema columnsSchema) {
            return new Header(queryId, columnsSchema);
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public LogicalSchema getSchema() {
            return this.columnsSchema;
        }

        @JsonCreator
        private static Header jsonCreator(@JsonProperty(value="queryId", required=true) QueryId queryId, @JsonProperty(value="schema", required=true) LogicalSchema columnsSchema) {
            return new Header(queryId, columnsSchema);
        }

        private Header(QueryId queryId, LogicalSchema columnsSchema) {
            this.queryId = Objects.requireNonNull(queryId, "queryId");
            this.columnsSchema = Objects.requireNonNull(columnsSchema, "columnsSchema");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Header header = (Header)o;
            return Objects.equals(this.queryId, header.queryId) && Objects.equals(this.columnsSchema, header.columnsSchema);
        }

        public int hashCode() {
            return Objects.hash(this.queryId, this.columnsSchema);
        }
    }

    @Immutable
    public static abstract class BaseRow {
        public String toString() {
            try {
                return OBJECT_MAPPER.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                return super.toString();
            }
        }
    }
}

