/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ServerClusterId {
    private static final String DEFAULT_ID = "";
    private static final String KAFKA_CLUSTER = "kafka-cluster";
    private static final String KSQL_CLUSTER = "ksql-cluster";
    private final String id;
    private final Scope scope;

    ServerClusterId(@JsonProperty(value="scope") Scope scope) {
        this.id = DEFAULT_ID;
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    public static ServerClusterId of(String kafkaClusterId, String ksqlClusterId) {
        return new ServerClusterId(new Scope(Collections.emptyList(), (Map<String, String>)ImmutableMap.of((Object)KAFKA_CLUSTER, (Object)kafkaClusterId, (Object)KSQL_CLUSTER, (Object)ksqlClusterId)));
    }

    public String getId() {
        return this.id;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerClusterId that = (ServerClusterId)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.scope, that.scope);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.scope);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Immutable
    public static final class Scope {
        private final ImmutableList<String> path;
        private final ImmutableMap<String, String> clusters;

        public Scope(@JsonProperty(value="path", required=true) List<String> path, @JsonProperty(value="clusters", required=true) Map<String, String> clusters) {
            this.path = ImmutableList.copyOf((Collection)Objects.requireNonNull(path, "path"));
            this.clusters = ImmutableMap.copyOf(Objects.requireNonNull(clusters, "clusters"));
        }

        public List<String> getPath() {
            return this.path;
        }

        public Map<String, String> getClusters() {
            return this.clusters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Scope scope = (Scope)o;
            return Objects.equals(this.path, scope.path) && Objects.equals(this.clusters, scope.clusters);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.clusters);
        }
    }
}

