/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.confluent.ksql.query.QueryId;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="commandStatus")
@JsonSubTypes(value={})
public class CommandStatus {
    private final Status status;
    private final String message;
    private final Optional<QueryId> queryId;

    public CommandStatus(Status status, String message) {
        this(status, message, Optional.empty());
    }

    @JsonCreator
    public CommandStatus(@JsonProperty(value="status") Status status, @JsonProperty(value="message") String message, @JsonProperty(value="queryId") Optional<QueryId> queryId) {
        this.status = status;
        this.message = message;
        this.queryId = queryId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<QueryId> getQueryId() {
        return this.queryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandStatus)) {
            return false;
        }
        CommandStatus that = (CommandStatus)o;
        return this.getStatus() == that.getStatus() && Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.getQueryId(), that.getQueryId());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getStatus(), this.getMessage(), this.getQueryId()});
    }

    public String toString() {
        return this.status.name() + ": " + this.message + ". Query ID: " + (this.queryId.isPresent() ? this.queryId.toString() : "<empty>");
    }

    public static enum Status {
        QUEUED,
        PARSING,
        EXECUTING,
        RUNNING,
        TERMINATED,
        SUCCESS,
        ERROR;

    }
}

