/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.ExecuteStatementResult;
import io.confluent.ksql.api.client.exception.KsqlClientException;
import java.util.concurrent.CompletableFuture;

final class DdlDmlRequestValidators {
    private DdlDmlRequestValidators() {
    }

    static boolean validateExecuteStatementRequest(String sql, CompletableFuture<ExecuteStatementResult> cf) {
        if (!sql.contains(";")) {
            cf.completeExceptionally(new KsqlClientException("Missing semicolon in SQL for executeStatement() request."));
            return false;
        }
        if (sql.indexOf(";") != sql.lastIndexOf(";")) {
            cf.completeExceptionally(new KsqlClientException("executeStatement() may only be used to execute one statement at a time."));
            return false;
        }
        return true;
    }
}

