/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.streams.serdes.avro.ConfigurationUtils;
import java.util.Map;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.serialization.Serializer;

@InterfaceStability.Unstable
public class ReflectionAvroSerializer<T>
implements Serializer<T> {
    private final KafkaAvroSerializer inner;

    public ReflectionAvroSerializer() {
        this.inner = new KafkaAvroSerializer();
    }

    ReflectionAvroSerializer(SchemaRegistryClient client) {
        this.inner = new KafkaAvroSerializer(client);
    }

    public void configure(Map<String, ?> serializerConfig, boolean isSerializerForRecordKeys) {
        this.inner.configure(ConfigurationUtils.withReflectionAvroEnabled(serializerConfig), isSerializerForRecordKeys);
    }

    public byte[] serialize(String topic, T record) {
        return this.inner.serialize(topic, record);
    }

    public void close() {
        this.inner.close();
    }
}

