/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.nio.ByteBuffer;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaRegistryIdentity {
    public static final int CURRENT_VERSION = 1;
    private Integer version = 1;
    private String host;
    private Integer port;
    private Boolean leaderEligibility;
    private String scheme;

    public SchemaRegistryIdentity(@JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="master_eligibility") Boolean leaderEligibility, @JsonProperty(value="scheme", defaultValue="http") String scheme) {
        this.host = host;
        this.port = port;
        this.leaderEligibility = leaderEligibility;
        this.scheme = scheme;
    }

    public static SchemaRegistryIdentity fromJson(String json) throws IOException {
        return (SchemaRegistryIdentity)JacksonMapper.INSTANCE.readValue(json, SchemaRegistryIdentity.class);
    }

    public static SchemaRegistryIdentity fromJson(ByteBuffer json) {
        try {
            byte[] jsonBytes = new byte[json.remaining()];
            json.get(jsonBytes);
            return (SchemaRegistryIdentity)JacksonMapper.INSTANCE.readValue(jsonBytes, SchemaRegistryIdentity.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error deserializing identity information", e);
        }
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonProperty(value="master_eligibility")
    public boolean getLeaderEligibility() {
        return this.leaderEligibility;
    }

    @JsonProperty(value="master_eligibility")
    public void setLeaderEligibility(Boolean eligibility) {
        this.leaderEligibility = eligibility;
    }

    @JsonProperty(value="scheme", defaultValue="http")
    public String getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme", defaultValue="http")
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public static int getCurrentVersion() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRegistryIdentity that = (SchemaRegistryIdentity)o;
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (!this.host.equals(that.host)) {
            return false;
        }
        if (!this.port.equals(that.port)) {
            return false;
        }
        if (!this.leaderEligibility.equals(that.leaderEligibility)) {
            return false;
        }
        return this.scheme.equals(that.scheme);
    }

    public int hashCode() {
        int result = this.port;
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.version;
        result = 31 * result + this.leaderEligibility.hashCode();
        result = 31 * result + this.scheme.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("version=" + this.version + ",");
        sb.append("host=" + this.host + ",");
        sb.append("port=" + this.port + ",");
        sb.append("scheme=" + this.scheme + ",");
        sb.append("leaderEligibility=" + this.leaderEligibility);
        return sb.toString();
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }

    public ByteBuffer toJsonBytes() {
        try {
            return ByteBuffer.wrap(JacksonMapper.INSTANCE.writeValueAsBytes((Object)this));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error serializing identity information", e);
        }
    }

    @JsonIgnore
    public String getUrl() {
        return String.format("%s://%s:%d", this.scheme, this.host, this.port);
    }
}

