/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.ServerClusterId;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/metadata")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class ServerMetadataResource {
    private static final Logger log = LoggerFactory.getLogger(ServerMetadataResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final SchemaRegistryConfig schemaRegistryConfig;

    public ServerMetadataResource(KafkaSchemaRegistry schemaRegistry, SchemaRegistryConfig schemaRegistryConfig) {
        this.schemaRegistry = schemaRegistry;
        this.schemaRegistryConfig = schemaRegistryConfig;
    }

    @GET
    @Path(value="/id")
    @ApiOperation(value="Get the server metadata")
    @ApiResponses(value={@ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    @PerformanceMetric(value="metadata.id")
    public ServerClusterId getClusterId() {
        String errorMessage = "Error while retrieving cluster information";
        try {
            String kafkaClusterId = this.schemaRegistry.getKafkaClusterId();
            String schemaRegistryClusterId = this.schemaRegistryConfig.getString("schema.registry.group.id");
            return ServerClusterId.of((String)kafkaClusterId, (String)schemaRegistryClusterId);
        }
        catch (SchemaRegistryException e) {
            log.debug("Error while retrieving cluster information", (Throwable)e);
            throw Errors.schemaRegistryException("Error while retrieving cluster information", e);
        }
    }
}

