/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.masterelector.zookeeper;

import io.confluent.kafka.schemaregistry.exceptions.IdGenerationException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryInitializationException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.MasterAwareSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.MasterElector;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import io.confluent.kafka.schemaregistry.utils.ZkUtils;
import java.io.IOException;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperMasterElector
implements MasterElector {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperMasterElector.class);
    private static final String MASTER_PATH = "/schema_registry_master";
    private final boolean isEligibleForMasterElection;
    private final ZkClient zkClient;
    private final ZkUtils zkUtils;
    private final SchemaRegistryIdentity myIdentity;
    private final String myIdentityString;
    private final MasterAwareSchemaRegistry schemaRegistry;

    public ZookeeperMasterElector(SchemaRegistryConfig config, SchemaRegistryIdentity myIdentity, MasterAwareSchemaRegistry schemaRegistry) throws SchemaRegistryStoreException {
        this.isEligibleForMasterElection = myIdentity.getMasterEligibility();
        this.zkUtils = config.zkUtils();
        this.zkClient = this.zkUtils.zkClient();
        this.myIdentity = myIdentity;
        try {
            this.myIdentityString = myIdentity.toJson();
        }
        catch (IOException e) {
            throw new SchemaRegistryStoreException(String.format("Error while serializing schema registry identity %s to json", myIdentity.toString()), e);
        }
        this.schemaRegistry = schemaRegistry;
        this.zkClient.subscribeStateChanges((IZkStateListener)new SessionExpirationListener());
        this.zkClient.subscribeDataChanges(MASTER_PATH, (IZkDataListener)new MasterChangeListener());
    }

    @Override
    public void init() throws SchemaRegistryTimeoutException, SchemaRegistryStoreException, SchemaRegistryInitializationException, IdGenerationException {
        if (this.isEligibleForMasterElection) {
            this.electMaster();
        } else {
            this.readCurrentMaster();
        }
    }

    @Override
    public void close() {
        this.zkClient.unsubscribeAll();
        this.zkUtils.close();
    }

    public void electMaster() throws SchemaRegistryStoreException, SchemaRegistryTimeoutException, SchemaRegistryInitializationException, IdGenerationException {
        SchemaRegistryIdentity masterIdentity = null;
        try {
            this.zkUtils.createEphemeralPathExpectConflict(MASTER_PATH, this.myIdentityString);
            log.info("Successfully elected the new master: " + this.myIdentityString);
            masterIdentity = this.myIdentity;
            this.schemaRegistry.setMaster(masterIdentity);
        }
        catch (ZkNodeExistsException znee) {
            this.readCurrentMaster();
        }
    }

    public void readCurrentMaster() throws SchemaRegistryTimeoutException, SchemaRegistryStoreException, SchemaRegistryInitializationException, IdGenerationException {
        SchemaRegistryIdentity masterIdentity = null;
        try {
            String masterIdentityString = this.zkUtils.readData(MASTER_PATH).getData();
            try {
                masterIdentity = SchemaRegistryIdentity.fromJson(masterIdentityString);
            }
            catch (IOException ioe) {
                log.error("Can't parse schema registry identity json string " + masterIdentityString);
            }
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
        if (this.myIdentity.equals(masterIdentity)) {
            log.error("The node's identity is same as elected master. Check the ``listeners`` config or the ``host.name`` and the ``port`` config");
            throw new SchemaRegistryInitializationException("Invalid identity");
        }
        this.schemaRegistry.setMaster(masterIdentity);
    }

    private class SessionExpirationListener
    implements IZkStateListener {
        public void handleStateChanged(Watcher.Event.KeeperState state) {
        }

        public void handleNewSession() throws Exception {
            if (ZookeeperMasterElector.this.isEligibleForMasterElection) {
                ZookeeperMasterElector.this.electMaster();
            } else {
                ZookeeperMasterElector.this.readCurrentMaster();
            }
        }

        public void handleSessionEstablishmentError(Throwable t) throws Exception {
            log.error("Failed to re-establish Zookeeper connection: ", t);
            throw new SchemaRegistryStoreException("Couldn't establish Zookeeper connection", t);
        }
    }

    private class MasterChangeListener
    implements IZkDataListener {
        public void handleDataChange(String dataPath, Object data) {
            try {
                if (ZookeeperMasterElector.this.isEligibleForMasterElection) {
                    ZookeeperMasterElector.this.electMaster();
                } else {
                    ZookeeperMasterElector.this.readCurrentMaster();
                }
            }
            catch (SchemaRegistryException e) {
                log.error("Error while reading the schema registry master", (Throwable)e);
            }
        }

        public void handleDataDeleted(String dataPath) throws Exception {
            if (ZookeeperMasterElector.this.isEligibleForMasterElection) {
                ZookeeperMasterElector.this.electMaster();
            } else {
                ZookeeperMasterElector.this.schemaRegistry.setMaster(null);
            }
        }
    }
}

