/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;

public class MockSchemaRegistryClientTest
extends ClusterTestHarness {
    private IndexedRecord createAvroRecord() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    private Properties createConsumerProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        props.put("group.id", "avroGroup");
        props.put("session.timeout.ms", "6000");
        props.put("heartbeat.interval.ms", "2000");
        props.put("auto.commit.interval.ms", "1000");
        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", KafkaAvroDeserializer.class);
        props.put("schema.registry.url", "mock://scope1");
        return props;
    }

    private Consumer<String, Object> createConsumer(Properties props) {
        return new KafkaConsumer(props);
    }

    private ArrayList<Object> consume(Consumer<String, Object> consumer, String topic, int numMessages) {
        ArrayList<Object> recordList = new ArrayList<Object>();
        consumer.subscribe(Arrays.asList(topic));
        int i = 0;
        while (i < numMessages) {
            ConsumerRecords records = consumer.poll(1000L);
            for (ConsumerRecord record : records) {
                recordList.add(record.value());
                ++i;
            }
        }
        consumer.close();
        return recordList;
    }

    private Properties createNewProducerProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        props.put("schema.registry.url", "mock://scope1");
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", KafkaAvroSerializer.class);
        return props;
    }

    private KafkaProducer createNewProducer(Properties props) {
        return new KafkaProducer(props);
    }

    private void newProduce(KafkaProducer producer, String topic, Object[] objects) {
        for (Object object : objects) {
            ProducerRecord record = new ProducerRecord(topic, object);
            producer.send(record);
        }
    }

    private Properties createProducerProps() {
        Properties props = new Properties();
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", KafkaAvroSerializer.class);
        props.put("bootstrap.servers", this.brokerList);
        props.put("schema.registry.url", "mock://scope1");
        return props;
    }

    private Producer<String, Object> createProducer(Properties props) {
        return new KafkaProducer(props);
    }

    private void produce(Producer<String, Object> producer, String topic, Object[] objects) {
        for (Object object : objects) {
            ProducerRecord message = new ProducerRecord(topic, object);
            producer.send(message);
        }
    }

    @Test
    public void testAvroProducer() {
        String topic = "testAvro";
        IndexedRecord avroRecord = this.createAvroRecord();
        Object[] objects = new Object[]{avroRecord};
        Properties producerProps = this.createProducerProps();
        Producer<String, Object> producer = this.createProducer(producerProps);
        this.produce(producer, topic, objects);
        Properties consumerProps = this.createConsumerProps();
        Consumer<String, Object> consumer = this.createConsumer(consumerProps);
        ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
        Assert.assertArrayEquals((Object[])objects, (Object[])recordList.toArray());
    }

    @Test
    public void testAvroNewProducer() {
        String topic = "testAvro";
        IndexedRecord avroRecord = this.createAvroRecord();
        Object[] objects = new Object[]{avroRecord, true, 130, 345L, Float.valueOf(1.23f), 2.34, "abc", "def".getBytes()};
        Properties producerProps = this.createNewProducerProps();
        KafkaProducer producer = this.createNewProducer(producerProps);
        this.newProduce(producer, topic, objects);
        Properties consumerProps = this.createConsumerProps();
        Consumer<String, Object> consumer = this.createConsumer(consumerProps);
        ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
        Assert.assertArrayEquals((Object[])objects, (Object[])recordList.toArray());
    }
}

