/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class SchemaRegistryKey
implements Comparable<SchemaRegistryKey> {
    @Min(value=0L)
    protected @Min(value=0L) int magicByte;
    @NotEmpty
    protected SchemaRegistryKeyType keyType;

    public SchemaRegistryKey(@JsonProperty(value="keytype") SchemaRegistryKeyType keyType) {
        this.keyType = keyType;
    }

    @JsonProperty(value="magic")
    public int getMagicByte() {
        return this.magicByte;
    }

    @JsonProperty(value="magic")
    public void setMagicByte(int magicByte) {
        this.magicByte = magicByte;
    }

    @JsonProperty(value="keytype")
    public SchemaRegistryKeyType getKeyType() {
        return this.keyType;
    }

    @JsonProperty(value="keytype")
    public void setKeyType(SchemaRegistryKeyType keyType) {
        this.keyType = keyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRegistryKey that = (SchemaRegistryKey)o;
        if (this.magicByte != that.magicByte) {
            return false;
        }
        return this.keyType.equals((Object)that.keyType);
    }

    public int hashCode() {
        int result = 31 * this.magicByte;
        result = 31 * result + this.keyType.hashCode();
        return result;
    }

    @Override
    public int compareTo(SchemaRegistryKey otherKey) {
        return this.keyType.compareTo(otherKey.keyType);
    }
}

