/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

@JsonPropertyOrder(value={"keytype", "subject", "version", "magic"})
public class SchemaKey
extends SubjectKey {
    private static final int MAGIC_BYTE = 1;
    @Min(value=1L)
    @NotEmpty
    private @Min(value=1L) @NotEmpty Integer version;

    public SchemaKey(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") int version) {
        super(SchemaRegistryKeyType.SCHEMA, subject);
        this.magicByte = 1;
        this.version = version;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaKey that = (SchemaKey)o;
        return this.version.equals(that.version);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{magic=" + this.magicByte + ",");
        sb.append("keytype=" + this.keyType.keyType + ",");
        sb.append("subject=" + this.getSubject() + ",");
        sb.append("version=" + this.version + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(SchemaRegistryKey o) {
        int compare = super.compareTo(o);
        if (compare == 0) {
            SchemaKey otherKey = (SchemaKey)o;
            return this.version - otherKey.version;
        }
        return compare;
    }
}

