/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/subjects")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SubjectsResource {
    private static final Logger log = LoggerFactory.getLogger(SubjectsResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public SubjectsResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @POST
    @Path(value="/{subject}")
    @ApiOperation(value="Check if a schema has already been registered under the specified subject. If so, this returns the schema string along with its globally unique identifier, its version under this subject and the subject name.")
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40401 -- Subject not found\nError code 40403 -- Schema not found"), @ApiResponse(code=500, message="Internal server error", response=Schema.class)})
    @PerformanceMetric(value="subjects.get-schema")
    public void lookUpSchemaUnderSubject(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Subject under which the schema will be registered", required=true) @PathParam(value="subject") String subject, @QueryParam(value="deleted") boolean lookupDeletedSchema, @ApiParam(value="Schema", required=true) @NotNull RegisterSchemaRequest request) {
        Schema schema = new Schema(subject, Integer.valueOf(0), Integer.valueOf(-1), request.getSchema());
        Schema matchingSchema = null;
        try {
            if (!this.schemaRegistry.hasSubjects(subject)) {
                throw Errors.subjectNotFoundException();
            }
            matchingSchema = this.schemaRegistry.lookUpSchemaUnderSubject(subject, schema, lookupDeletedSchema);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while looking up schema under subject " + subject, e);
        }
        if (matchingSchema == null) {
            throw Errors.schemaNotFoundException();
        }
        asyncResponse.resume((Object)matchingSchema);
    }

    @GET
    @Valid
    @ApiOperation(value="Get a list of registered subjects.")
    @ApiResponses(value={@ApiResponse(code=500, message="Error code 50001 -- Error in the backend datastore")})
    @PerformanceMetric(value="subjects.list")
    public Set<String> list() {
        try {
            return this.schemaRegistry.listSubjects();
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while listing subjects", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while listing subjects", e);
        }
    }

    @DELETE
    @Path(value="/{subject}")
    @ApiOperation(value="Deletes the specified subject and its associated compatibility level if registered. It is recommended to use this API only when a topic needs to be recycled or in development environment.", response=Integer.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40401 -- Subject not found"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend datastore")})
    @PerformanceMetric(value="subjects.delete-subject")
    public void deleteSubject(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @ApiParam(value="the name of the subject", required=true) @PathParam(value="subject") String subject) {
        List<Integer> deletedVersions;
        try {
            if (!this.schemaRegistry.hasSubjects(subject)) {
                throw Errors.subjectNotFoundException();
            }
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            deletedVersions = this.schemaRegistry.deleteSubjectOrForward(headerProperties, subject);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while deleting the subject " + subject, e);
        }
        asyncResponse.resume(deletedVersions);
    }
}

