/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestIncompatibleAvroSchemaException;
import org.junit.Assert;
import org.junit.Test;

public class RestApiCompatibilityTest
extends ClusterTestHarness {
    public RestApiCompatibilityTest() {
        super(1, true, AvroCompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testCompatibility() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString;
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        String incompatibleSchemaString = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString;
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
            Assert.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a conflict status", (long)RestIncompatibleAvroSchemaException.DEFAULT_ERROR_CODE, (long)e.getStatus());
        }
        String nonAvroSchemaString = "non-avro schema string";
        try {
            this.restApp.restClient.registerSchema(nonAvroSchemaString, subject);
            Assert.fail((String)"Registering a non-avro schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a bad request status", (long)42201L, (long)e.getErrorCode());
        }
        String schemaString2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}").canonicalString;
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering a compatible schema should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(schemaString2, subject));
    }

    @Test
    public void testCompatibilityLevelChangeToNone() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString;
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        String incompatibleSchemaString = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString;
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
            Assert.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a conflict status", (long)RestIncompatibleAvroSchemaException.DEFAULT_ERROR_CODE, (long)e.getStatus());
        }
        Assert.assertEquals((String)"Changing compatibility level should succeed", (Object)AvroCompatibilityLevel.NONE.name, (Object)this.restApp.restClient.updateCompatibility(AvroCompatibilityLevel.NONE.name, null).getCompatibilityLevel());
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
        }
        catch (RestClientException e) {
            Assert.fail((String)"Registering an incompatible schema should succeed after bumping down the compatibility level to none");
        }
    }

    @Test
    public void testCompatibilityLevelChangeToBackward() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString;
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        Assert.assertEquals((String)"Default compatibility level should be backward", (Object)AvroCompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        Assert.assertEquals((String)"Changing compatibility level should succeed", (Object)AvroCompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.updateCompatibility(AvroCompatibilityLevel.FORWARD.name, null).getCompatibilityLevel());
        Assert.assertEquals((String)"New compatibility level should be forward", (Object)AvroCompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        String schemaString2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString;
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(schemaString2, subject));
        Assert.assertEquals((String)"Changing compatibility level should succeed", (Object)AvroCompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.updateCompatibility(AvroCompatibilityLevel.BACKWARD.name, null).getCompatibilityLevel());
        Assert.assertEquals((String)"Updated compatibility level should be backward", (Object)AvroCompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        String schemaString3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\"}]}").canonicalString;
        try {
            this.restApp.restClient.registerSchema(schemaString3, subject);
            Assert.fail((String)"Registering a forward compatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a conflict status", (long)RestIncompatibleAvroSchemaException.DEFAULT_ERROR_CODE, (long)e.getStatus());
        }
        String schemaString4 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"foo\"}]}").canonicalString;
        int expectedIdSchema4 = 3;
        Assert.assertEquals((String)"Registering should succeed with backwards compatible schema", (long)expectedIdSchema4, (long)this.restApp.restClient.registerSchema(schemaString4, subject));
    }
}

