/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryRestApplication;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.server.Server;

public class RestApp {
    public final Properties prop = new Properties();
    public RestService restClient;
    public SchemaRegistryRestApplication restApp;
    public Server restServer;
    public String restConnect;

    public RestApp(int port, String zkConnect, String kafkaTopic) {
        this(port, zkConnect, kafkaTopic, AvroCompatibilityLevel.NONE.name, null);
    }

    public RestApp(int port, String zkConnect, String kafkaTopic, String compatibilityType, Properties schemaRegistryProps) {
        this(port, zkConnect, null, kafkaTopic, compatibilityType, true, schemaRegistryProps);
    }

    public RestApp(int port, String zkConnect, String kafkaTopic, String compatibilityType, boolean masterEligibility, Properties schemaRegistryProps) {
        this(port, zkConnect, null, kafkaTopic, compatibilityType, masterEligibility, schemaRegistryProps);
    }

    public RestApp(int port, String zkConnect, String bootstrapBrokers, String kafkaTopic, String compatibilityType, boolean masterEligibility, Properties schemaRegistryProps) {
        if (schemaRegistryProps != null) {
            this.prop.putAll((Map<?, ?>)schemaRegistryProps);
        }
        this.prop.setProperty("port", Integer.valueOf(port).toString());
        if (zkConnect != null) {
            this.prop.setProperty("kafkastore.connection.url", zkConnect);
        }
        if (bootstrapBrokers != null) {
            this.prop.setProperty("kafkastore.bootstrap.servers", bootstrapBrokers);
        }
        this.prop.put("kafkastore.topic", kafkaTopic);
        this.prop.put("avro.compatibility.level", compatibilityType);
        this.prop.put("master.eligibility", (Object)masterEligibility);
    }

    public void start() throws Exception {
        this.restApp = new SchemaRegistryRestApplication(this.prop);
        this.restServer = this.restApp.createServer();
        this.restServer.start();
        this.restConnect = this.restServer.getURI().toString();
        if (this.restConnect.endsWith("/")) {
            this.restConnect = this.restConnect.substring(0, this.restConnect.length() - 1);
        }
        this.restClient = new RestService(this.restConnect);
    }

    public void stop() throws Exception {
        this.restClient = null;
        if (this.restServer != null) {
            this.restServer.stop();
            this.restServer.join();
        }
    }

    public void addConfigs(Properties props) {
        this.prop.putAll((Map<?, ?>)props);
    }

    public boolean isMaster() {
        return this.restApp.schemaRegistry().isMaster();
    }

    public void setMaster(SchemaRegistryIdentity schemaRegistryIdentity) throws SchemaRegistryException {
        this.restApp.schemaRegistry().setMaster(schemaRegistryIdentity);
    }

    public SchemaRegistryIdentity myIdentity() {
        return this.restApp.schemaRegistry().myIdentity();
    }

    public SchemaRegistryIdentity masterIdentity() {
        return this.restApp.schemaRegistry().masterIdentity();
    }

    public SchemaRegistry schemaRegistry() {
        return this.restApp.schemaRegistry();
    }
}

