/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import io.confluent.kafka.schemaregistry.utils.ZkData;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kafka.cluster.Broker;
import kafka.zk.BrokerIdZNode;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.kafka.common.config.ConfigException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZkUtils
implements AutoCloseable {
    public static final String BROKERS_PATH = "/brokers";
    public static final String BROKER_IDS_PATH = "/brokers/ids";
    private final ZkClient zkClient;
    private final List<ACL> acls;
    private volatile boolean isNamespacePresent;

    public ZkUtils(String zkConnect, int sessionTimeoutMs, int connectionTimeout, boolean isSecure) {
        ZkConnection zkConnection = new ZkConnection(zkConnect, sessionTimeoutMs);
        this.zkClient = new ZkClient((IZkConnection)zkConnection, connectionTimeout, (ZkSerializer)new ZkStringSerializer());
        if (isSecure) {
            this.acls = new ArrayList<ACL>();
            this.acls.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
            this.acls.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
        } else {
            this.acls = Collections.unmodifiableList(ZooDefs.Ids.OPEN_ACL_UNSAFE);
        }
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public List<Broker> getAllBrokersInCluster() {
        List<String> brokerIds = this.getChildrenParentMayNotExist(BROKER_IDS_PATH);
        brokerIds.sort(Comparator.naturalOrder());
        return brokerIds.stream().map(Integer::parseInt).map(i -> this.getBrokerInfo((int)i)).filter(b -> !Objects.isNull(b)).collect(Collectors.toList());
    }

    private List<String> getChildrenParentMayNotExist(String path) {
        try {
            return this.zkClient.getChildren(path);
        }
        catch (ZkNoNodeException e) {
            return null;
        }
    }

    private Broker getBrokerInfo(int brokerId) {
        String brokerInfo = this.readDataMaybeNull("/brokers/ids/" + brokerId).getData();
        return brokerInfo != null ? this.parseBrokerJson(brokerId, brokerInfo) : null;
    }

    private Broker parseBrokerJson(int id, String jsonString) {
        return BrokerIdZNode.decode((int)id, (byte[])jsonString.getBytes(StandardCharsets.UTF_8)).broker();
    }

    public void makeSurePersistentPathExists(String path) {
        if (!this.zkClient.exists(path)) {
            this.createPersistent(path, true);
        }
    }

    public void createEphemeralPathExpectConflict(String path, String data) {
        block4: {
            try {
                this.createEphemeralPath(path, data);
            }
            catch (ZkNodeExistsException e) {
                String storedData = null;
                try {
                    storedData = this.readData(path).getData();
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if (storedData != null && storedData.equals(data)) break block4;
                throw e;
            }
        }
    }

    private void createEphemeralPath(String path, String data) {
        try {
            this.createEphemeral(path, data);
        }
        catch (ZkNoNodeException e) {
            this.createParentPath(path);
            this.createEphemeral(path, data);
        }
    }

    public void createPersistentPath(String path, String data) {
        try {
            this.createPersistent(path, data);
        }
        catch (ZkNoNodeException e) {
            this.createParentPath(path);
            this.createPersistent(path, data);
        }
    }

    private void createParentPath(String path) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (!parentDir.isEmpty()) {
            this.checkNamespace();
            this.zkClient.createPersistent(parentDir, true, this.acls);
        }
    }

    private void checkNamespace() {
        if (!this.isNamespacePresent && !this.zkClient.exists("/")) {
            throw new ConfigException("Zookeeper namespace does not exist");
        }
        this.isNamespacePresent = true;
    }

    public int conditionalUpdatePersistentPath(String path, String data, int expectVersion) {
        try {
            Stat stat = this.zkClient.writeDataReturnStat(path, (Object)data, expectVersion);
            return stat.getVersion();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void updatePersistentPath(String path, String data) {
        this.zkClient.writeData(path, (Object)data);
    }

    public ZkData readData(String path) {
        Stat stat = new Stat();
        String data = (String)this.zkClient.readData(path, stat);
        return new ZkData(data, stat);
    }

    public ZkData readDataMaybeNull(String path) {
        String data;
        Stat stat = new Stat();
        try {
            data = (String)this.zkClient.readData(path, stat);
        }
        catch (ZkNoNodeException e) {
            data = null;
        }
        return new ZkData(data, stat);
    }

    public boolean delete(String path) {
        return this.zkClient.delete(path);
    }

    private void createPersistent(String path, Object data) {
        this.checkNamespace();
        this.zkClient.createPersistent(path, data, this.acls);
    }

    private void createPersistent(String path, boolean createParents) {
        this.checkNamespace();
        this.zkClient.createPersistent(path, createParents, this.acls);
    }

    private void createEphemeral(String path, Object data) {
        this.checkNamespace();
        this.zkClient.createEphemeral(path, data, this.acls);
    }

    @Override
    public void close() {
        this.zkClient.close();
    }

    private static class ZkStringSerializer
    implements ZkSerializer {
        private ZkStringSerializer() {
        }

        public byte[] serialize(Object data) throws ZkMarshallingError {
            try {
                return ((String)data).getBytes("UTF-8");
            }
            catch (Exception e) {
                throw new ZkMarshallingError((Throwable)e);
            }
        }

        public Object deserialize(byte[] bytes) throws ZkMarshallingError {
            try {
                return bytes == null ? null : new String(bytes, "UTF-8");
            }
            catch (Exception e) {
                throw new ZkMarshallingError((Throwable)e);
            }
        }
    }
}

