/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.tools;

import io.confluent.common.utils.AbstractPerformanceTest;
import io.confluent.common.utils.PerformanceStats;
import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;

public class SchemaRegistryPerformance
extends AbstractPerformanceTest {
    long targetRegisteredSchemas;
    long targetSchemasPerSec;
    String baseUrl;
    RestService restService;
    String subject;
    long registeredSchemas = 0L;
    long successfullyRegisteredSchemas = 0L;

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage: java " + SchemaRegistryPerformance.class.getName() + " schema_registry_url subject num_schemas target_schemas_per_sec");
            System.exit(1);
        }
        String baseUrl = args[0];
        String subject = args[1];
        int numSchemas = Integer.parseInt(args[2]);
        int targetSchemasPerSec = Integer.parseInt(args[3]);
        SchemaRegistryPerformance perf = new SchemaRegistryPerformance(baseUrl, subject, numSchemas, targetSchemasPerSec);
        perf.run(targetSchemasPerSec);
        perf.close();
    }

    public SchemaRegistryPerformance(String baseUrl, String subject, long numSchemas, long targetSchemasPerSec) throws Exception {
        super(numSchemas);
        this.baseUrl = baseUrl;
        this.restService = new RestService(baseUrl);
        this.subject = subject;
        this.targetRegisteredSchemas = numSchemas;
        this.targetSchemasPerSec = targetSchemasPerSec;
        ConfigUpdateRequest request = new ConfigUpdateRequest();
        request.setCompatibilityLevel(AvroCompatibilityLevel.NONE.name);
        this.restService.updateConfig(request, null);
    }

    private static String makeSchema(long num) {
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f" + num + "\"}]}";
        return AvroUtils.parseSchema((String)schemaString).canonicalString;
    }

    protected void doIteration(PerformanceStats.Callback cb) {
        String schema = SchemaRegistryPerformance.makeSchema(this.registeredSchemas);
        try {
            this.restService.registerSchema(schema, this.subject);
            ++this.successfullyRegisteredSchemas;
        }
        catch (IOException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        catch (RestClientException e) {
            System.out.println("Problem registering schema: " + e.getMessage());
        }
        ++this.registeredSchemas;
        cb.onCompletion(1, 0L);
    }

    protected void close() {
        if ((double)this.successfullyRegisteredSchemas / (double)this.targetRegisteredSchemas < 0.99) {
            throw new RuntimeException("Too many schema registration errors: " + this.successfullyRegisteredSchemas + " registered successfully out of " + this.targetRegisteredSchemas + " attempted");
        }
    }

    protected boolean finished(int iteration) {
        return this.targetRegisteredSchemas == this.registeredSchemas;
    }

    protected boolean runningFast(int iteration, float elapsed) {
        return (float)iteration / elapsed > (float)this.targetSchemasPerSec;
    }
}

