/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

@JsonPropertyOrder(value={"keytype", "subject", "version", "magic"})
public class SchemaKey
extends SchemaRegistryKey {
    private static final int MAGIC_BYTE = 1;
    @NotEmpty
    private String subject;
    @Min(value=1L)
    @NotEmpty
    private Integer version;

    public SchemaKey(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") int version) {
        super(SchemaRegistryKeyType.SCHEMA);
        this.magicByte = 1;
        this.subject = subject;
        this.version = version;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SchemaKey that = (SchemaKey)o;
        if (!this.subject.equals(that.subject)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.subject.hashCode();
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{magic=" + this.magicByte + ",");
        sb.append("keytype=" + this.keyType.keyType + ",");
        sb.append("subject=" + this.subject + ",");
        sb.append("version=" + this.version + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(SchemaRegistryKey o) {
        int compare = super.compareTo(o);
        if (compare == 0) {
            SchemaKey otherKey = (SchemaKey)o;
            int subjectComp = this.subject.compareTo(otherKey.subject);
            return subjectComp == 0 ? this.version - otherKey.version : subjectComp;
        }
        return compare;
    }
}

