/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;

@JsonPropertyOrder(value={"keytype", "subject", "magic"})
public class ConfigKey
extends SchemaRegistryKey {
    private static final int MAGIC_BYTE = 0;
    private String subject;

    public ConfigKey(@JsonProperty(value="subject") String subject) {
        super(SchemaRegistryKeyType.CONFIG);
        this.subject = subject;
        this.magicByte = 0;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ConfigKey that = (ConfigKey)o;
        if (this.subject != null && that.subject != null) {
            return this.subject.equals(that.subject);
        }
        return this.subject == null && that.subject == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.subject != null) {
            result = 31 * result + this.subject.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{magic=" + this.magicByte + ",");
        sb.append("keytype=" + this.keyType.keyType + ",");
        sb.append("subject=" + this.subject + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(SchemaRegistryKey o) {
        int compare = super.compareTo(o);
        if (compare == 0) {
            ConfigKey otherKey = (ConfigKey)o;
            if (this.subject == null && otherKey.subject == null) {
                return 0;
            }
            if (this.subject == null) {
                return -1;
            }
            if (otherKey.subject == null) {
                return 1;
            }
            return this.subject.compareTo(otherKey.subject);
        }
        return compare;
    }
}

