/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.exceptions.IncompatibleSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidVersionException;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownMasterException;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/subjects/{subject}/versions")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SubjectVersionsResource {
    private static final Logger log = LoggerFactory.getLogger(SubjectVersionsResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public SubjectVersionsResource(KafkaSchemaRegistry registry) {
        this.schemaRegistry = registry;
    }

    @GET
    @Path(value="/{version}")
    @PerformanceMetric(value="subjects.versions.get-schema")
    public Schema getSchema(@PathParam(value="subject") String subject, @PathParam(value="version") String version) {
        VersionId versionId = null;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        Schema schema = null;
        String errorMessage = null;
        try {
            schema = this.schemaRegistry.validateAndGetSchema(subject, versionId, false);
        }
        catch (SchemaRegistryStoreException e) {
            errorMessage = "Error while retrieving schema for subject " + subject + " with version " + version + " from the schema registry";
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        return schema;
    }

    @GET
    @Path(value="/{version}/schema")
    @PerformanceMetric(value="subjects.versions.get-schema.only")
    public String getSchemaOnly(@PathParam(value="subject") String subject, @PathParam(value="version") String version) {
        return this.getSchema(subject, version).getSchema();
    }

    @GET
    @PerformanceMetric(value="subjects.versions.list")
    public List<Integer> list(@PathParam(value="subject") String subject) {
        Iterator<Schema> allSchemasForThisTopic = null;
        ArrayList<Integer> allVersions = new ArrayList<Integer>();
        String errorMessage = "Error while validating that subject " + subject + " exists in the registry";
        try {
            if (!this.schemaRegistry.listSubjects().contains(subject)) {
                throw Errors.subjectNotFoundException();
            }
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        errorMessage = "Error while listing all versions for subject " + subject;
        try {
            allSchemasForThisTopic = this.schemaRegistry.getAllVersions(subject, false);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        while (allSchemasForThisTopic.hasNext()) {
            Schema schema = allSchemasForThisTopic.next();
            allVersions.add(schema.getVersion());
        }
        return allVersions;
    }

    @POST
    @PerformanceMetric(value="subjects.versions.register")
    public void register(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @PathParam(value="subject") String subjectName, @NotNull RegisterSchemaRequest request) {
        int id;
        Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
        Schema schema = new Schema(subjectName, Integer.valueOf(request.getVersion() != null ? request.getVersion() : 0), Integer.valueOf(request.getId() != null ? request.getId() : -1), request.getSchema());
        try {
            id = this.schemaRegistry.registerOrForward(subjectName, schema, headerProperties);
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidAvroException("Input schema is an invalid Avro schema", e);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Register operation timed out", e);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Register schema operation failed while writing to the Kafka store", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding register schema request to the master", e);
        }
        catch (IncompatibleSchemaException e) {
            throw Errors.incompatibleSchemaException("Schema being registered is incompatible with an earlier schema", e);
        }
        catch (UnknownMasterException e) {
            throw Errors.unknownMasterException("Master not known.", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while registering schema", e);
        }
        RegisterSchemaResponse registerSchemaResponse = new RegisterSchemaResponse();
        registerSchemaResponse.setId(id);
        asyncResponse.resume((Object)registerSchemaResponse);
    }

    @DELETE
    @Path(value="/{version}")
    @PerformanceMetric(value="subjects.versions.deleteSchemaVersion-schema")
    public void deleteSchemaVersion(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @PathParam(value="subject") String subject, @PathParam(value="version") String version) {
        VersionId versionId = null;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        Schema schema = null;
        String errorMessage = null;
        try {
            schema = this.schemaRegistry.validateAndGetSchema(subject, versionId, false);
        }
        catch (SchemaRegistryStoreException e) {
            errorMessage = "Error while retrieving schema for subject " + subject + " with version " + version + " from the schema registry";
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        try {
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.deleteSchemaVersionOrForward(headerProperties, subject, schema);
        }
        catch (SchemaRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Delete Schema Version operation timed out", e);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Delete Schema Version operation failed while writing to the Kafka store", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding delete schema version request to the master", e);
        }
        catch (UnknownMasterException e) {
            throw Errors.unknownMasterException("Master not known.", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while deleting Schema Version", e);
        }
        asyncResponse.resume((Object)schema.getVersion());
    }
}

