/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidVersionException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.HashMap;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/compatibility")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class CompatibilityResource {
    private static final Logger log = LoggerFactory.getLogger(CompatibilityResource.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public CompatibilityResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Path(value="/subjects/{subject}/versions/{version}")
    @PerformanceMetric(value="compatibility.subjects.versions.verify")
    public void lookUpSchemaUnderSubject(@Suspended AsyncResponse asyncResponse, @HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="Accept") String accept, @PathParam(value="subject") String subject, @PathParam(value="version") String version, @NotNull RegisterSchemaRequest request) {
        HashMap<String, String> headerProperties = new HashMap<String, String>();
        headerProperties.put("Content-Type", contentType);
        headerProperties.put("Accept", accept);
        boolean isCompatible = false;
        CompatibilityCheckResponse compatibilityCheckResponse = new CompatibilityCheckResponse();
        String errorMessage = "Error while retrieving list of all subjects";
        Schema schemaForSpecifiedVersion = null;
        VersionId versionId = CompatibilityResource.parseVersionId(version);
        try {
            schemaForSpecifiedVersion = this.schemaRegistry.get(subject, versionId.getVersionId(), false);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        catch (SchemaRegistryException e) {
            throw Errors.storeException("Error while retrieving schema for subject " + subject + " and version " + versionId.getVersionId(), e);
        }
        this.registerWithError(subject, errorMessage);
        if (schemaForSpecifiedVersion == null) {
            if (!versionId.isLatest()) throw Errors.versionNotFoundException();
            isCompatible = true;
            compatibilityCheckResponse.setIsCompatible(isCompatible);
            asyncResponse.resume((Object)compatibilityCheckResponse);
            return;
        }
        try {
            isCompatible = this.schemaRegistry.isCompatible(subject, request.getSchema(), schemaForSpecifiedVersion.getSchema());
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidAvroException("Invalid input schema " + request.getSchema(), e);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while getting compatibility level for subject " + subject, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while getting compatibility level for subject " + subject, e);
        }
        compatibilityCheckResponse.setIsCompatible(isCompatible);
        asyncResponse.resume((Object)compatibilityCheckResponse);
    }

    private static VersionId parseVersionId(String version) {
        VersionId versionId;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException();
        }
        return versionId;
    }

    private void registerWithError(String subject, String errorMessage) {
        try {
            if (!this.schemaRegistry.listSubjects().contains(subject)) {
                throw Errors.subjectNotFoundException();
            }
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
    }
}

