/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.masterelector.kafka;

import io.confluent.kafka.schemaregistry.masterelector.kafka.SchemaRegistryProtocol;
import io.confluent.kafka.schemaregistry.masterelector.kafka.SchemaRegistryRebalanceListener;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.internals.AbstractCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SchemaRegistryCoordinator
extends AbstractCoordinator
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryCoordinator.class);
    public static final String SR_SUBPROTOCOL_V0 = "v0";
    private final SchemaRegistryIdentity identity;
    private SchemaRegistryProtocol.Assignment assignmentSnapshot;
    private final SchemaRegistryRebalanceListener listener;

    public SchemaRegistryCoordinator(LogContext logContext, ConsumerNetworkClient client, String groupId, int rebalanceTimeoutMs, int sessionTimeoutMs, int heartbeatIntervalMs, Metrics metrics, String metricGrpPrefix, Time time, long retryBackoffMs, SchemaRegistryIdentity identity, SchemaRegistryRebalanceListener listener) {
        super(logContext, client, groupId, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, metrics, metricGrpPrefix, time, retryBackoffMs, true);
        this.identity = identity;
        this.assignmentSnapshot = null;
        this.listener = listener;
    }

    public String protocolType() {
        return "sr";
    }

    public void poll(long timeout) {
        long elapsed;
        long remaining;
        long start;
        long now = start = this.time.milliseconds();
        do {
            if (this.coordinatorUnknown()) {
                this.ensureCoordinatorReady();
                now = this.time.milliseconds();
            }
            if (this.needRejoin()) {
                this.ensureActiveGroup();
                now = this.time.milliseconds();
            }
            this.pollHeartbeat(now);
            elapsed = now - start;
            remaining = timeout - elapsed;
            this.client.poll(Math.min(Math.max(0L, remaining), this.timeToNextHeartbeat(now)));
        } while ((remaining = timeout - (elapsed = (now = this.time.milliseconds()) - start)) > 0L);
    }

    public List<JoinGroupRequest.ProtocolMetadata> metadata() {
        ByteBuffer metadata = SchemaRegistryProtocol.serializeMetadata(this.identity);
        return Collections.singletonList(new JoinGroupRequest.ProtocolMetadata(SR_SUBPROTOCOL_V0, metadata));
    }

    protected void onJoinComplete(int generation, String memberId, String protocol, ByteBuffer memberAssignment) {
        this.assignmentSnapshot = SchemaRegistryProtocol.deserializeAssignment(memberAssignment);
        this.listener.onAssigned(this.assignmentSnapshot, generation);
    }

    protected Map<String, ByteBuffer> performAssignment(String kafkaLeaderId, String protocol, Map<String, ByteBuffer> allMemberMetadata) {
        log.debug("Performing assignment");
        HashMap<String, SchemaRegistryIdentity> memberConfigs = new HashMap<String, SchemaRegistryIdentity>();
        for (Map.Entry<String, ByteBuffer> entry : allMemberMetadata.entrySet()) {
            SchemaRegistryIdentity identity = SchemaRegistryProtocol.deserializeMetadata(entry.getValue());
            memberConfigs.put(entry.getKey(), identity);
        }
        log.debug("Member information: {}", memberConfigs);
        SchemaRegistryIdentity masterIdentity = null;
        String masterKafkaId = null;
        HashSet<String> urls = new HashSet<String>();
        for (Map.Entry entry : memberConfigs.entrySet()) {
            boolean smallerIdentity;
            String kafkaMemberId = (String)entry.getKey();
            SchemaRegistryIdentity memberIdentity = (SchemaRegistryIdentity)entry.getValue();
            urls.add(memberIdentity.getUrl());
            boolean eligible = memberIdentity.getMasterEligibility();
            boolean bl = smallerIdentity = masterIdentity == null || memberIdentity.getUrl().compareTo(masterIdentity.getUrl()) < 0;
            if (!eligible || !smallerIdentity) continue;
            masterKafkaId = kafkaMemberId;
            masterIdentity = memberIdentity;
        }
        short error = 0;
        if (urls.size() != memberConfigs.size()) {
            log.error("Found duplicate URLs for schema registry group members. This indicates a misconfiguration and is common when executing in containers. Use the host.name configuration to set each instance's advertised host name to a value that is routable from all other schema registry instances.");
            error = 1;
        }
        HashMap<String, ByteBuffer> groupAssignment = new HashMap<String, ByteBuffer>();
        SchemaRegistryProtocol.Assignment assignment = new SchemaRegistryProtocol.Assignment(error, masterKafkaId, masterIdentity);
        log.debug("Assignment: {}", (Object)assignment);
        for (String member : memberConfigs.keySet()) {
            groupAssignment.put(member, SchemaRegistryProtocol.serializeAssignment(assignment));
        }
        return groupAssignment;
    }

    protected void onJoinPrepare(int generation, String memberId) {
        log.debug("Revoking previous assignment {}", (Object)this.assignmentSnapshot);
        if (this.assignmentSnapshot != null) {
            this.listener.onRevoked();
        }
    }

    protected boolean needRejoin() {
        return super.needRejoin() || this.assignmentSnapshot == null;
    }
}

