/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.NoopKey;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.SerializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import java.io.IOException;
import java.util.Map;

public class SchemaRegistrySerializer
implements Serializer<SchemaRegistryKey, SchemaRegistryValue> {
    @Override
    public byte[] serializeKey(SchemaRegistryKey key) throws SerializationException {
        try {
            return new ObjectMapper().writeValueAsBytes((Object)key);
        }
        catch (IOException e) {
            throw new SerializationException("Error while serializing schema key" + key.toString(), e);
        }
    }

    @Override
    public byte[] serializeValue(SchemaRegistryValue value) throws SerializationException {
        try {
            return new ObjectMapper().writeValueAsBytes((Object)value);
        }
        catch (IOException e) {
            throw new SerializationException("Error while serializing value schema value " + value.toString(), e);
        }
    }

    @Override
    public SchemaRegistryKey deserializeKey(byte[] key) throws SerializationException {
        SchemaRegistryKey schemaKey = null;
        SchemaRegistryKeyType keyType = null;
        try {
            try {
                Map keyObj = null;
                keyObj = (Map)new ObjectMapper().readValue(key, (TypeReference)new TypeReference<Map<Object, Object>>(){});
                keyType = SchemaRegistryKeyType.forName((String)keyObj.get("keytype"));
                schemaKey = keyType == SchemaRegistryKeyType.CONFIG ? (SchemaRegistryKey)new ObjectMapper().readValue(key, ConfigKey.class) : (keyType == SchemaRegistryKeyType.NOOP ? (SchemaRegistryKey)new ObjectMapper().readValue(key, NoopKey.class) : (SchemaRegistryKey)new ObjectMapper().readValue(key, SchemaKey.class));
            }
            catch (JsonProcessingException e) {
                String type = "unknown";
                if (keyType == SchemaRegistryKeyType.CONFIG) {
                    type = SchemaRegistryKeyType.CONFIG.name();
                } else if (keyType == SchemaRegistryKeyType.SCHEMA) {
                    type = SchemaRegistryKeyType.SCHEMA.name();
                } else if (keyType == SchemaRegistryKeyType.NOOP) {
                    type = SchemaRegistryKeyType.NOOP.name();
                }
                throw new SerializationException("Failed to deserialize " + type + " key", e);
            }
        }
        catch (IOException e) {
            throw new SerializationException("Error while deserializing schema key", e);
        }
        return schemaKey;
    }

    @Override
    public SchemaRegistryValue deserializeValue(SchemaRegistryKey key, byte[] value) throws SerializationException {
        SchemaRegistryValue schemaRegistryValue = null;
        if (key.getKeyType().equals((Object)SchemaRegistryKeyType.CONFIG)) {
            try {
                schemaRegistryValue = (SchemaRegistryValue)new ObjectMapper().readValue(value, ConfigValue.class);
            }
            catch (IOException e) {
                throw new SerializationException("Error while deserializing config", e);
            }
        } else if (key.getKeyType().equals((Object)SchemaRegistryKeyType.SCHEMA)) {
            try {
                schemaRegistryValue = (SchemaRegistryValue)new ObjectMapper().readValue(value, SchemaValue.class);
            }
            catch (IOException e) {
                throw new SerializationException("Error while deserializing schema", e);
            }
        } else {
            throw new SerializationException("Unrecognized key type. Must be one of schema or config");
        }
        return schemaRegistryValue;
    }

    @Override
    public void close() {
    }

    public void configure(Map<String, ?> stringMap) {
    }
}

