/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import jersey.repackaged.com.google.common.base.Preconditions;

public class MD5 {
    private final byte[] md5;

    public MD5(byte[] md5) {
        Preconditions.checkNotNull((Object)md5, (Object)"Tried to instantiate MD5 object with null byte array.");
        Preconditions.checkArgument((md5.length == 16 ? 1 : 0) != 0, (Object)"Tried to instantiate MD5 object with invalid byte array.");
        this.md5 = md5;
    }

    public static MD5 ofString(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new MD5(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.md5);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof MD5)) {
            return false;
        }
        MD5 otherMd5 = (MD5)o;
        return Arrays.equals(this.md5, otherMd5.md5);
    }
}

