/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.MD5;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.StoreUpdateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoreMessageHandler
implements StoreUpdateHandler<SchemaRegistryKey, SchemaRegistryValue> {
    private static final Logger log = LoggerFactory.getLogger(KafkaStoreMessageHandler.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public KafkaStoreMessageHandler(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @Override
    public void handleUpdate(SchemaRegistryKey key, SchemaRegistryValue schema) {
        if (key.getKeyType() == SchemaRegistryKeyType.SCHEMA) {
            MD5 md5;
            SchemaIdAndSubjects schemaIdAndSubjects;
            SchemaValue schemaObj = (SchemaValue)schema;
            SchemaKey schemaKey = (SchemaKey)key;
            this.schemaRegistry.guidToSchemaKey.put(schemaObj.getId(), schemaKey);
            if (this.schemaRegistry.getMaxIdInKafkaStore() < schemaObj.getId()) {
                this.schemaRegistry.setMaxIdInKafkaStore(schemaObj.getId());
            }
            if ((schemaIdAndSubjects = this.schemaRegistry.schemaHashToGuid.get(md5 = MD5.ofString(schemaObj.getSchema()))) == null) {
                schemaIdAndSubjects = new SchemaIdAndSubjects(schemaObj.getId());
            }
            schemaIdAndSubjects.addSubjectAndVersion(schemaKey.getSubject(), schemaKey.getVersion());
            this.schemaRegistry.schemaHashToGuid.put(md5, schemaIdAndSubjects);
        }
    }
}

