/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/schemas")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SchemasResource {
    public static final String MESSAGE_SCHEMA_NOT_FOUND = "Schema not found.";
    private static final Logger log = LoggerFactory.getLogger(SchemasResource.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public SchemasResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @GET
    @Path(value="/ids/{id}")
    @PerformanceMetric(value="schemas.ids.get-schema")
    public SchemaString getSchema(@PathParam(value="id") Integer id) {
        SchemaString schema = null;
        String errorMessage = "Error while retrieving schema with id " + id + " from the schema " + "registry";
        try {
            schema = this.schemaRegistry.get(id);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (schema == null) {
            throw Errors.schemaNotFoundException();
        }
        return schema;
    }
}

