/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.resources.CompatibilityResource;
import io.confluent.kafka.schemaregistry.rest.resources.ConfigResource;
import io.confluent.kafka.schemaregistry.rest.resources.RootResource;
import io.confluent.kafka.schemaregistry.rest.resources.SchemasResource;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectVersionsResource;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectsResource;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import java.util.Properties;
import javax.ws.rs.core.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryRestApplication
extends Application<SchemaRegistryConfig> {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryRestApplication.class);
    private KafkaSchemaRegistry schemaRegistry = null;

    public SchemaRegistryRestApplication(Properties props) throws RestConfigException {
        this(new SchemaRegistryConfig(props));
    }

    public SchemaRegistryRestApplication(SchemaRegistryConfig config) {
        super((RestConfig)config);
    }

    public void setupResources(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig) {
        try {
            this.schemaRegistry = new KafkaSchemaRegistry(schemaRegistryConfig, new SchemaRegistrySerializer());
            this.schemaRegistry.init();
        }
        catch (SchemaRegistryException e) {
            log.error("Error starting the schema registry", (Throwable)e);
            System.exit(1);
        }
        config.register(RootResource.class);
        config.register((Object)new ConfigResource(this.schemaRegistry));
        config.register((Object)new SubjectsResource(this.schemaRegistry));
        config.register((Object)new SchemasResource(this.schemaRegistry));
        config.register((Object)new SubjectVersionsResource(this.schemaRegistry));
        config.register((Object)new CompatibilityResource(this.schemaRegistry));
    }

    public void onShutdown() {
        this.schemaRegistry.close();
    }

    public KafkaSchemaRegistry schemaRegistry() {
        return this.schemaRegistry;
    }
}

