/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="download")
public class DownloadSchemaRegistryMojo
extends SchemaRegistryMojo {
    public static final String PERCENT_REPLACEMENT = "_x";
    @Parameter(required=false)
    String schemaExtension;
    @Parameter(required=true)
    List<String> subjectPatterns = new ArrayList<String>();
    @Parameter(required=false)
    List<String> versions = new ArrayList<String>();
    @Parameter(required=true)
    File outputDirectory;
    @Parameter(required=false)
    boolean encodeSubject = true;

    Map<String, ParsedSchema> downloadSchemas(List<String> subjects, List<String> versionsToDownload) throws MojoExecutionException {
        LinkedHashMap<String, ParsedSchema> results = new LinkedHashMap<String, ParsedSchema>();
        if (versionsToDownload.size() != subjects.size()) {
            throw new MojoExecutionException("Number of versions specified should be same as number of subjects");
        }
        for (int i = 0; i < subjects.size(); ++i) {
            try {
                Optional schema;
                this.getLog().info((CharSequence)String.format("Downloading metadata for %s.for version %s", subjects.get(i), versionsToDownload.get(i)));
                SchemaMetadata schemaMetadata = this.client().getLatestSchemaMetadata(subjects.get(i));
                if (!versionsToDownload.get(i).equalsIgnoreCase("latest")) {
                    Integer maxVersion = schemaMetadata.getVersion();
                    if (maxVersion < Integer.parseInt(versionsToDownload.get(i))) {
                        throw new MojoExecutionException(String.format("Max possible version for %s is %d", subjects.get(i), maxVersion));
                    }
                    schemaMetadata = this.client().getSchemaMetadata(subjects.get(i), Integer.parseInt(versionsToDownload.get(i)));
                }
                if (!(schema = this.client().parseSchema(new Schema(null, schemaMetadata))).isPresent()) {
                    throw new MojoExecutionException(String.format("Error while parsing schema for %s", subjects.get(i)));
                }
                results.put(subjects.get(i), (ParsedSchema)schema.get());
                continue;
            }
            catch (Exception ex) {
                throw new MojoExecutionException(String.format("Exception thrown while downloading metadata for %s.", subjects.get(i)), ex);
            }
        }
        return results;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Collection allSubjects;
        if (this.skip) {
            this.getLog().info((CharSequence)"Plugin execution has been skipped");
            return;
        }
        this.outputDirValidation();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String subject : this.subjectPatterns) {
            try {
                this.getLog().debug((CharSequence)String.format("Creating pattern for '%s'", subject));
                Pattern pattern = Pattern.compile(subject);
                patterns.add(pattern);
            }
            catch (Exception ex) {
                throw new IllegalStateException(String.format("Exception thrown while creating pattern '%s'", subject), ex);
            }
        }
        try {
            this.getLog().info((CharSequence)"Getting all subjects on schema registry...");
            allSubjects = this.client().getAllSubjects();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Exception thrown", ex);
        }
        this.getLog().info((CharSequence)String.format("Schema Registry has %s subject(s).", allSubjects.size()));
        ArrayList<String> subjectsToDownload = new ArrayList<String>();
        ArrayList<String> versionsToDownload = new ArrayList<String>();
        if (!this.versions.isEmpty() && this.versions.size() != this.subjectPatterns.size()) {
            throw new IllegalStateException("versions size should be same as subjectPatterns size");
        }
        block18: for (Object subject : allSubjects) {
            for (int i = 0; i < patterns.size(); ++i) {
                this.getLog().debug((CharSequence)String.format("Checking '%s' against pattern '%s'", subject, ((Pattern)patterns.get(i)).pattern()));
                Matcher matcher = ((Pattern)patterns.get(i)).matcher((CharSequence)subject);
                if (!matcher.matches()) continue;
                this.getLog().debug((CharSequence)String.format("'%s' matches pattern '%s' so downloading.", subject, ((Pattern)patterns.get(i)).pattern()));
                if (this.versions.isEmpty()) {
                    versionsToDownload.add("latest");
                } else {
                    versionsToDownload.add(this.versions.get(i));
                }
                subjectsToDownload.add((String)subject);
                continue block18;
            }
        }
        Map<String, ParsedSchema> subjectToSchema = this.downloadSchemas(subjectsToDownload, versionsToDownload);
        for (Map.Entry entry : subjectToSchema.entrySet()) {
            String subject = (String)entry.getKey();
            String encodedSubject = this.encodeSubject ? this.encode(subject) : subject;
            String fileName = String.format("%s%s", encodedSubject, this.getExtension((ParsedSchema)entry.getValue()));
            File outputFile = new File(this.outputDirectory, fileName);
            this.getLog().info((CharSequence)String.format("Writing schema for Subject(%s) to %s.", subject, outputFile));
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    writer.write(((ParsedSchema)entry.getValue()).toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (Exception ex) {
                throw new MojoExecutionException(String.format("Exception thrown while writing subject('%s') schema to %s", subject, outputFile), ex);
            }
        }
        try {
            this.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while closing schema registry client", (Exception)e);
        }
    }

    public void outputDirValidation() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().debug((CharSequence)String.format("Checking if '%s' exists and is not a directory.", this.outputDirectory));
            if (this.outputDirectory.exists() && !this.outputDirectory.isDirectory()) {
                throw new IllegalStateException("outputDirectory must be a directory");
            }
            this.getLog().debug((CharSequence)String.format("Checking if outputDirectory('%s') exists.", this.outputDirectory));
            if (!this.outputDirectory.isDirectory()) {
                this.getLog().debug((CharSequence)String.format("Creating outputDirectory('%s').", this.outputDirectory));
                if (!this.outputDirectory.mkdirs()) {
                    throw new IllegalStateException("Could not create output directory " + this.outputDirectory);
                }
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Exception thrown while creating outputDirectory", ex);
        }
    }

    private String getExtension(ParsedSchema parsedSchema) {
        if (this.schemaExtension != null) {
            return this.schemaExtension;
        }
        switch (parsedSchema.schemaType()) {
            case "AVRO": {
                return ".avsc";
            }
            case "JSON": {
                return ".schema.json";
            }
            case "PROTOBUF": {
                return ".proto";
            }
        }
        return ".txt";
    }

    protected String encode(String subject) {
        try {
            String newSubject = URLEncoder.encode(subject, "UTF-8");
            return newSubject.replaceAll("%", PERCENT_REPLACEMENT);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)String.format("Could not encode subject '%s'", subject));
            return subject;
        }
    }
}

