/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.maven.MojoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Utils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class SchemaRegistryMojo
extends AbstractMojo {
    @Parameter(required=true)
    List<String> schemaRegistryUrls;
    @Parameter
    String userInfoConfig;
    @Parameter
    Map<String, String> httpHeaders;
    @Parameter(property="kafka-schema-registry.skip")
    boolean skip;
    @Parameter(required=false)
    List<String> schemaProviders = new ArrayList<String>();
    @Parameter
    Map<String, String> configs = new HashMap<String, String>();
    protected SchemaRegistryClient client;

    void client(SchemaRegistryClient client) {
        this.client = client;
    }

    protected SchemaRegistryClient client() {
        if (null == this.client) {
            HashMap<String, String> config = new HashMap<String, String>();
            if (this.configs != null && !this.configs.isEmpty()) {
                config.putAll(this.configs);
            }
            if (this.userInfoConfig != null) {
                config.put("basic.auth.credentials.source", "USER_INFO");
                config.put("basic.auth.user.info", this.userInfoConfig);
            }
            List<SchemaProvider> providers = this.schemaProviders != null && !this.schemaProviders.isEmpty() ? this.schemaProviders() : MojoUtils.defaultSchemaProviders();
            this.client = new CachedSchemaRegistryClient(this.schemaRegistryUrls, 1000, providers, config, this.httpHeaders);
        }
        return this.client;
    }

    private List<SchemaProvider> schemaProviders() {
        return this.schemaProviders.stream().map(s -> {
            try {
                return (SchemaProvider)Utils.newInstance((String)s, SchemaProvider.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

