/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTags;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@io.swagger.v3.oas.annotations.media.Schema(description="Schema definition")
public class SchemaString {
    private String subject;
    private Integer version;
    private String guid;
    private String schemaType = "AVRO";
    private String schemaString;
    private List<SchemaReference> references = Collections.emptyList();
    private Metadata metadata = null;
    private RuleSet ruleSet = null;
    private List<SchemaTags> schemaTags;
    private Integer maxId;
    private Long timestamp;
    private Boolean deleted;

    public SchemaString() {
    }

    public SchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    public SchemaString(Schema schema) {
        this.subject = schema.getSubject();
        this.version = schema.getVersion();
        this.guid = schema.getGuid();
        this.schemaType = schema.getSchemaType();
        this.schemaString = schema.getSchema();
        this.references = schema.getReferences();
        this.metadata = schema.getMetadata();
        this.ruleSet = schema.getRuleSet();
        this.schemaTags = schema.getSchemaTags();
        this.timestamp = schema.getTimestamp();
        this.deleted = schema.getDeleted();
    }

    public SchemaString(String subject, Integer version, Schema schema) {
        this.subject = subject;
        this.version = version;
        this.guid = schema.getGuid();
        this.schemaType = schema.getSchemaType();
        this.schemaString = schema.getSchema();
        this.references = schema.getReferences();
        this.metadata = schema.getMetadata();
        this.ruleSet = schema.getRuleSet();
        this.schemaTags = schema.getSchemaTags();
        this.timestamp = schema.getTimestamp();
        this.deleted = schema.getDeleted();
    }

    public SchemaString copy() {
        SchemaString schema = new SchemaString();
        schema.setSubject(this.getSubject());
        schema.setVersion(this.getVersion());
        schema.setGuid(this.getGuid());
        schema.setSchemaType(this.getSchemaType());
        schema.setSchemaString(this.getSchemaString());
        schema.setReferences(this.getReferences());
        schema.setMetadata(this.getMetadata());
        schema.setRuleSet(this.getRuleSet());
        schema.setSchemaTags(this.getSchemaTags());
        schema.setMaxId(this.getMaxId());
        schema.setTimestamp(this.getTimestamp());
        schema.setDeleted(this.getDeleted());
        return schema;
    }

    public static SchemaString fromJson(String json) throws IOException {
        return (SchemaString)JacksonMapper.INSTANCE.readValue(json, SchemaString.class);
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="guid")
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    public void setGuid(String guid) {
        this.guid = guid;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema type", example="AVRO")
    @JsonProperty(value="schemaType")
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema string identified by the ID", example="{\"schema\": \"{\"type\": \"string\"}\"}")
    @JsonProperty(value="schema")
    public String getSchemaString() {
        return this.schemaString;
    }

    @JsonProperty(value="schema")
    public void setSchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="References to other schemas")
    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="User-defined metadata")
    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema rule set")
    @JsonProperty(value="ruleSet")
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    @JsonProperty(value="ruleSet")
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema tags")
    @JsonProperty(value="schemaTags")
    public List<SchemaTags> getSchemaTags() {
        return this.schemaTags;
    }

    @JsonProperty(value="schemaTags")
    public void setSchemaTags(List<SchemaTags> schemaTags) {
        this.schemaTags = schemaTags;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Maximum ID", example="1")
    @JsonProperty(value="maxId")
    public Integer getMaxId() {
        return this.maxId;
    }

    @JsonProperty(value="maxId")
    public void setMaxId(Integer maxId) {
        this.maxId = maxId;
    }

    @JsonProperty(value="ts")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="ts")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaString that = (SchemaString)o;
        return Objects.equals(this.subject, that.subject) && Objects.equals(this.version, that.version) && Objects.equals(this.guid, that.guid) && Objects.equals(this.schemaString, that.schemaString) && Objects.equals(this.references, that.references) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet) && Objects.equals(this.maxId, that.maxId);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.version, this.guid, this.schemaType, this.schemaString, this.references, this.metadata, this.ruleSet, this.maxId);
    }
}

