/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTags;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Schema tags register request")
public class TagSchemaRequest {
    private static final String newVersionDescription = "The new version should be the latest version in the subject + 1. If set, the new version will be encoded to the schema metadata.";
    private Integer newVersion;
    private List<SchemaTags> tagsToAdd;
    private List<SchemaTags> tagsToRemove;
    private Metadata metadata;
    private RuleSet ruleSet;
    private RuleSet rulesToMerge;
    private List<String> rulesToRemove;

    @Schema(description="The new version should be the latest version in the subject + 1. If set, the new version will be encoded to the schema metadata.")
    @JsonProperty(value="newVersion")
    public Integer getNewVersion() {
        return this.newVersion;
    }

    @JsonProperty(value="newVersion")
    public void setNewVersion(Integer newVersion) {
        this.newVersion = newVersion;
    }

    @JsonProperty(value="tagsToAdd")
    public List<SchemaTags> getTagsToAdd() {
        return this.tagsToAdd;
    }

    @JsonProperty(value="tagsToAdd")
    public void setTagsToAdd(List<SchemaTags> tagsToAdd) {
        this.tagsToAdd = tagsToAdd;
    }

    @JsonProperty(value="tagsToRemove")
    public List<SchemaTags> getTagsToRemove() {
        return this.tagsToRemove;
    }

    @JsonProperty(value="tagsToRemove")
    public void setTagsToRemove(List<SchemaTags> tagsToRemove) {
        this.tagsToRemove = tagsToRemove;
    }

    @Schema(description="User-defined metadata")
    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Schema(description="Schema rule set")
    @JsonProperty(value="ruleSet")
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    @JsonProperty(value="ruleSet")
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    @JsonProperty(value="rulesToMerge")
    public RuleSet getRulesToMerge() {
        return this.rulesToMerge;
    }

    @JsonProperty(value="rulesToMerge")
    public void setRulesToMerge(RuleSet rulesToMerge) {
        this.rulesToMerge = rulesToMerge;
    }

    @JsonProperty(value="rulesToRemove")
    public List<String> getRulesToRemove() {
        return this.rulesToRemove;
    }

    @JsonProperty(value="rulesToRemove")
    public void setRulesToRemove(List<String> rulesToRemove) {
        this.rulesToRemove = rulesToRemove;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagSchemaRequest tagSchemaRequest = (TagSchemaRequest)o;
        return Objects.equals(this.newVersion, tagSchemaRequest.newVersion) && Objects.equals(this.tagsToAdd, tagSchemaRequest.tagsToAdd) && Objects.equals(this.tagsToRemove, tagSchemaRequest.tagsToRemove) && Objects.equals(this.metadata, tagSchemaRequest.metadata) && Objects.equals(this.ruleSet, tagSchemaRequest.ruleSet) && Objects.equals(this.rulesToMerge, tagSchemaRequest.rulesToMerge) && Objects.equals(this.rulesToRemove, tagSchemaRequest.rulesToRemove);
    }

    public int hashCode() {
        return Objects.hash(this.newVersion, this.tagsToAdd, this.tagsToRemove, this.metadata, this.ruleSet, this.rulesToMerge, this.rulesToRemove);
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }

    public static Map<SchemaEntity, Set<String>> schemaTagsListToMap(List<SchemaTags> schemaTags) {
        if (schemaTags == null || schemaTags.isEmpty()) {
            return Collections.emptyMap();
        }
        return schemaTags.stream().collect(Collectors.toMap(SchemaTags::getSchemaEntity, entry -> new LinkedHashSet<String>(entry.getTags()), (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }, LinkedHashMap::new));
    }
}

