/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSchemaRegistryClient
implements SchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(MockSchemaRegistryClient.class);
    private static final String WILDCARD = "*";
    private String defaultCompatibility = "BACKWARD";
    private final Map<String, Map<ParsedSchema, Integer>> schemaCache = new ConcurrentHashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<String, Map<ParsedSchema, Integer>> schemaIdCache = new ConcurrentHashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<String, Map<Integer, ParsedSchema>> idCache = new ConcurrentHashMap<String, Map<Integer, ParsedSchema>>();
    private final Map<String, Map<ParsedSchema, Integer>> versionCache = new ConcurrentHashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<String, String> compatibilityCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> modes = new ConcurrentHashMap<String, String>();
    private final Map<String, AtomicInteger> ids = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, SchemaProvider> providers;
    private static final String NO_SUBJECT = "";

    public MockSchemaRegistryClient() {
        this(null);
    }

    public MockSchemaRegistryClient(List<SchemaProvider> providers) {
        this.providers = providers != null && !providers.isEmpty() ? providers.stream().collect(Collectors.toMap(p -> p.schemaType(), p -> p)) : Collections.singletonMap("AVRO", new AvroSchemaProvider());
        HashMap<String, MockSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, MockSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        SchemaProvider schemaProvider;
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("No provider found for schema type " + schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schemaString, references);
    }

    private int getIdFromRegistry(String subject, ParsedSchema schema, boolean registerRequest, int id) throws IOException, RestClientException {
        Map idSchemaMap = this.idCache.computeIfAbsent(subject, k -> new ConcurrentHashMap());
        if (!idSchemaMap.isEmpty()) {
            for (Map.Entry entry : idSchemaMap.entrySet()) {
                if (!this.schemasEqual((ParsedSchema)entry.getValue(), schema)) continue;
                if (registerRequest) {
                    if (id >= 0 && id != (Integer)entry.getKey()) continue;
                    this.generateVersion(subject, schema);
                }
                return (Integer)entry.getKey();
            }
        } else if (!registerRequest) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        if (registerRequest) {
            int schemaId;
            String context = MockSchemaRegistryClient.toQualifiedContext(subject);
            Map schemaIdMap = this.schemaIdCache.computeIfAbsent(context, k -> new ConcurrentHashMap());
            if (id >= 0) {
                schemaId = id;
                schemaIdMap.put(schema, schemaId);
            } else {
                schemaId = schemaIdMap.computeIfAbsent(schema, k -> this.ids.computeIfAbsent(context, c -> new AtomicInteger(0)).incrementAndGet());
            }
            this.generateVersion(subject, schema);
            idSchemaMap.put(schemaId, schema);
            return schemaId;
        }
        throw new RestClientException("Schema Not Found", 404, 40403);
    }

    private boolean schemasEqual(ParsedSchema schema1, ParsedSchema schema2) {
        return schema1.canonicalString().equals(schema2.canonicalString()) || schema1.deepEquals(schema2);
    }

    private void generateVersion(String subject, ParsedSchema schema) {
        List<Integer> versions = this.allVersions(subject);
        int currentVersion = versions.isEmpty() ? 1 : versions.get(versions.size() - 1) + 1;
        Map schemaVersionMap = this.versionCache.computeIfAbsent(subject, k -> new ConcurrentHashMap());
        schemaVersionMap.put(schema, currentVersion);
    }

    private ParsedSchema getSchemaBySubjectAndIdFromRegistry(String subject, int id) throws IOException, RestClientException {
        ParsedSchema schema;
        ParsedSchema schema2;
        Map<Integer, ParsedSchema> idSchemaMap = this.idCache.get(subject);
        if (idSchemaMap != null && (schema2 = idSchemaMap.get(id)) != null) {
            return schema2;
        }
        String context = MockSchemaRegistryClient.toQualifiedContext(subject);
        if (!context.equals(subject) && (idSchemaMap = this.idCache.get(context)) != null && (schema = idSchemaMap.get(id)) != null) {
            return schema;
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    @Override
    public int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1);
    }

    @Override
    public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1, normalize);
    }

    @Override
    public int register(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        return this.register(subject, schema, version, id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int register(String subject, ParsedSchema schema, int version, int id, boolean normalize) throws IOException, RestClientException {
        Map schemaIdMap;
        Integer schemaId;
        if (normalize) {
            schema = schema.normalize();
        }
        if ((schemaId = (Integer)(schemaIdMap = this.schemaCache.computeIfAbsent(subject, k -> new ConcurrentHashMap())).get(schema)) != null && (id < 0 || id == schemaId)) {
            return schemaId;
        }
        MockSchemaRegistryClient mockSchemaRegistryClient = this;
        synchronized (mockSchemaRegistryClient) {
            schemaId = (Integer)schemaIdMap.get(schema);
            if (schemaId != null && (id < 0 || id == schemaId)) {
                return schemaId;
            }
            int retrievedId = this.getIdFromRegistry(subject, schema, true, id);
            schemaIdMap.put(schema, retrievedId);
            String context = MockSchemaRegistryClient.toQualifiedContext(subject);
            Map idSchemaMap = this.idCache.computeIfAbsent(context, k -> new ConcurrentHashMap());
            idSchemaMap.put(retrievedId, schema);
            return retrievedId;
        }
    }

    @Override
    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.getSchemaBySubjectAndId(NO_SUBJECT, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map idSchemaMap;
        ParsedSchema schema;
        if (subject == null) {
            subject = NO_SUBJECT;
        }
        if ((schema = (ParsedSchema)(idSchemaMap = this.idCache.computeIfAbsent(subject, k -> new ConcurrentHashMap())).get(id)) != null) {
            return schema;
        }
        MockSchemaRegistryClient mockSchemaRegistryClient = this;
        synchronized (mockSchemaRegistryClient) {
            schema = (ParsedSchema)idSchemaMap.get(id);
            if (schema != null) {
                return schema;
            }
            ParsedSchema retrievedSchema = this.getSchemaBySubjectAndIdFromRegistry(subject, id);
            idSchemaMap.put(id, retrievedSchema);
            return retrievedSchema;
        }
    }

    private Stream<ParsedSchema> getSchemasForSubject(String subject, boolean latestOnly) {
        try {
            List<Integer> versions = this.getAllVersions(subject);
            if (latestOnly) {
                int length = versions.size();
                versions = versions.subList(length - 1, length);
            }
            LinkedList<SchemaMetadata> schemaMetadata = new LinkedList<SchemaMetadata>();
            for (Integer version : versions) {
                schemaMetadata.add(this.getSchemaMetadata(subject, version));
            }
            LinkedList<ParsedSchema> schemas = new LinkedList<ParsedSchema>();
            for (SchemaMetadata metadata : schemaMetadata) {
                schemas.add(this.getSchemaBySubjectAndId(subject, metadata.getId()));
            }
            return schemas.stream();
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        Stream<String> validSubjects = this.getAllSubjects().stream().filter(subject -> subject.startsWith(subjectPrefix));
        return validSubjects.flatMap(subject -> this.getSchemasForSubject((String)subject, latestOnly)).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        return this.idCache.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(id)).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Collection<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        return this.idCache.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(id)).map(e -> {
            ParsedSchema schema = (ParsedSchema)((Map)e.getValue()).get(id);
            int version = this.versionCache.get(e.getKey()).get(schema);
            return new SubjectVersion((String)e.getKey(), version);
        }).collect(Collectors.toList());
    }

    private int getLatestVersion(String subject) throws IOException, RestClientException {
        List<Integer> versions = this.getAllVersions(subject);
        if (versions.isEmpty()) {
            throw new IOException("No schema registered under subject!");
        }
        return versions.get(versions.size() - 1);
    }

    @Override
    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        ParsedSchema schema = null;
        Map<ParsedSchema, Integer> schemaVersionMap = this.versionCache.get(subject);
        if (schemaVersionMap == null) {
            throw new RuntimeException(new RestClientException("Subject Not Found", 404, 40401));
        }
        int maxVersion = -1;
        for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
            if (version == -1) {
                if (entry.getValue() <= maxVersion) continue;
                schema = entry.getKey();
                maxVersion = entry.getValue();
                continue;
            }
            if (entry.getValue() != version) continue;
            schema = entry.getKey();
        }
        if (schema == null) {
            throw new RuntimeException(new RestClientException("Subject Not Found", 404, 40401));
        }
        if (maxVersion != -1) {
            version = maxVersion;
        }
        int id = -1;
        Map<Integer, ParsedSchema> idSchemaMap = this.idCache.get(subject);
        for (Map.Entry<Integer, ParsedSchema> entry : idSchemaMap.entrySet()) {
            if (!this.schemasEqual(entry.getValue(), schema)) continue;
            id = entry.getKey();
        }
        return new Schema(subject, version, id, schema.schemaType(), schema.references(), schema.canonicalString());
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        ParsedSchema schema = null;
        Map<ParsedSchema, Integer> schemaVersionMap = this.versionCache.get(subject);
        if (schemaVersionMap == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
            if (entry.getValue() != version) continue;
            schema = entry.getKey();
        }
        if (schema == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        int id = -1;
        Map<Integer, ParsedSchema> idSchemaMap = this.idCache.get(subject);
        for (Map.Entry<Integer, ParsedSchema> entry : idSchemaMap.entrySet()) {
            if (!this.schemasEqual(entry.getValue(), schema)) continue;
            id = entry.getKey();
        }
        return new SchemaMetadata(id, version, schema.schemaType(), schema.references(), schema.canonicalString());
    }

    @Override
    public SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        int version = this.getLatestVersion(subject);
        return this.getSchemaMetadata(subject, version);
    }

    @Override
    public int getVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getVersion(subject, schema, false);
    }

    @Override
    public int getVersion(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map<ParsedSchema, Integer> versions;
        if (normalize) {
            schema = schema.normalize();
        }
        if ((versions = this.versionCache.get(subject)) != null) {
            return versions.get(schema);
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    @Override
    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        List<Integer> allVersions = this.allVersions(subject);
        if (!allVersions.isEmpty()) {
            return allVersions;
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    private List<Integer> allVersions(String subject) {
        ArrayList<Integer> allVersions = new ArrayList<Integer>();
        Map<ParsedSchema, Integer> versions = this.versionCache.get(subject);
        if (versions != null) {
            allVersions.addAll(versions.values());
            Collections.sort(allVersions);
        }
        return allVersions;
    }

    @Override
    public boolean testCompatibility(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        CompatibilityLevel compatibilityLevel;
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            compatibility = this.defaultCompatibility;
        }
        if ((compatibilityLevel = CompatibilityLevel.forName(compatibility)) == null) {
            return false;
        }
        ArrayList<ParsedSchema> schemaHistory = new ArrayList<ParsedSchema>();
        for (int version : this.allVersions(subject)) {
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(subject, version);
            schemaHistory.add(this.getSchemaBySubjectAndIdFromRegistry(subject, schemaMetadata.getId()));
        }
        return newSchema.isCompatible(compatibilityLevel, schemaHistory).isEmpty();
    }

    @Override
    public int getId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getId(subject, schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map schemaIdMap;
        Integer schemaId;
        if (normalize) {
            schema = schema.normalize();
        }
        if ((schemaId = (Integer)(schemaIdMap = this.schemaCache.computeIfAbsent(subject, k -> new ConcurrentHashMap())).get(schema)) != null) {
            return schemaId;
        }
        MockSchemaRegistryClient mockSchemaRegistryClient = this;
        synchronized (mockSchemaRegistryClient) {
            schemaId = (Integer)schemaIdMap.get(schema);
            if (schemaId != null) {
                return schemaId;
            }
            int retrievedId = this.getIdFromRegistry(subject, schema, false, -1);
            schemaIdMap.put(schema, retrievedId);
            String context = MockSchemaRegistryClient.toQualifiedContext(subject);
            Map idSchemaMap = this.idCache.computeIfAbsent(context, k -> new ConcurrentHashMap());
            idSchemaMap.put(retrievedId, schema);
            return retrievedId;
        }
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSubject(null, subject, isPermanent);
    }

    @Override
    public synchronized List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        this.schemaCache.remove(subject);
        this.idCache.remove(subject);
        Map<ParsedSchema, Integer> versions = this.versionCache.remove(subject);
        this.compatibilityCache.remove(subject);
        return versions != null ? versions.values().stream().sorted().collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSchemaVersion(null, subject, version, isPermanent);
    }

    @Override
    public synchronized Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        Map<ParsedSchema, Integer> schemaVersionMap = this.versionCache.get(subject);
        if (schemaVersionMap != null) {
            for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
                if (!entry.getValue().equals(Integer.valueOf(version))) continue;
                schemaVersionMap.values().remove(entry.getValue());
                if (isPermanent) {
                    this.idCache.get(subject).remove(entry.getValue());
                    this.schemaCache.get(subject).remove(entry.getKey());
                }
                return Integer.valueOf(version);
            }
        }
        return -1;
    }

    @Override
    public List<String> testCompatibilityVerbose(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        CompatibilityLevel compatibilityLevel;
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            compatibility = this.defaultCompatibility;
        }
        if ((compatibilityLevel = CompatibilityLevel.forName(compatibility)) == null) {
            return Collections.singletonList("Compatibility level not specified.");
        }
        ArrayList<ParsedSchema> schemaHistory = new ArrayList<ParsedSchema>();
        for (int version : this.allVersions(subject)) {
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(subject, version);
            schemaHistory.add(this.getSchemaBySubjectAndIdFromRegistry(subject, schemaMetadata.getId()));
        }
        return newSchema.isCompatible(compatibilityLevel, schemaHistory);
    }

    @Override
    public String updateCompatibility(String subject, String compatibility) throws IOException, RestClientException {
        if (subject == null) {
            this.defaultCompatibility = compatibility;
            return compatibility;
        }
        this.compatibilityCache.put(subject, compatibility);
        return compatibility;
    }

    @Override
    public String getCompatibility(String subject) throws IOException, RestClientException {
        if (subject == null) {
            return this.defaultCompatibility;
        }
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        return compatibility;
    }

    @Override
    public String setMode(String mode) throws IOException, RestClientException {
        this.modes.put(WILDCARD, mode);
        return mode;
    }

    @Override
    public String setMode(String mode, String subject) throws IOException, RestClientException {
        this.modes.put(subject, mode);
        return mode;
    }

    @Override
    public String getMode() throws IOException, RestClientException {
        return this.modes.getOrDefault(WILDCARD, "READWRITE");
    }

    @Override
    public String getMode(String subject) throws IOException, RestClientException {
        String mode = this.modes.get(subject);
        if (mode == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        return mode;
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        ArrayList<String> results = new ArrayList<String>(this.schemaCache.keySet());
        Collections.sort(results);
        return results;
    }

    @Override
    public Collection<String> getAllSubjectsByPrefix(String subjectPrefix) throws IOException, RestClientException {
        Stream<String> validSubjects = this.getAllSubjects().stream().filter(subject -> subjectPrefix == null || subject.startsWith(subjectPrefix));
        return validSubjects.collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public synchronized void reset() {
        this.schemaCache.clear();
        this.schemaIdCache.clear();
        this.idCache.clear();
        this.versionCache.clear();
        this.compatibilityCache.clear();
        this.modes.clear();
        this.ids.clear();
    }

    private static String toQualifiedContext(String subject) {
        QualifiedSubject qualifiedSubject = QualifiedSubject.create("default", subject);
        return qualifiedSubject != null ? qualifiedSubject.toQualifiedContext() : NO_SUBJECT;
    }
}

