/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.avro.Schemas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(AvroSchema.class);
    public static final String TYPE = "AVRO";
    private static final SchemaValidator BACKWARD_VALIDATOR = new SchemaValidatorBuilder().canReadStrategy().validateLatest();
    private final Schema schemaObj;
    private String canonicalString;
    private final Integer version;
    private final List<SchemaReference> references;
    private final Map<String, String> resolvedReferences;
    private final boolean isNew;

    public AvroSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public AvroSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        this(schemaString, references, resolvedReferences, version, false);
    }

    public AvroSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version, boolean isNew) {
        this.isNew = isNew;
        Schema.Parser parser = this.getParser();
        for (String schema : resolvedReferences.values()) {
            parser.parse(schema);
        }
        this.schemaObj = parser.parse(schemaString);
        this.references = Collections.unmodifiableList(references);
        this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
        this.version = version;
    }

    public AvroSchema(Schema schemaObj) {
        this(schemaObj, null);
    }

    public AvroSchema(Schema schemaObj, Integer version) {
        this.isNew = false;
        this.schemaObj = schemaObj;
        this.references = Collections.emptyList();
        this.resolvedReferences = Collections.emptyMap();
        this.version = version;
    }

    private AvroSchema(Schema schemaObj, String canonicalString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version, boolean isNew) {
        this.isNew = isNew;
        this.schemaObj = schemaObj;
        this.canonicalString = canonicalString;
        this.references = references;
        this.resolvedReferences = resolvedReferences;
        this.version = version;
    }

    public AvroSchema copy() {
        return new AvroSchema(this.schemaObj, this.canonicalString, this.references, this.resolvedReferences, this.version, this.isNew);
    }

    protected Schema.Parser getParser() {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(this.isNew());
        return parser;
    }

    public Schema rawSchema() {
        return this.schemaObj;
    }

    @Override
    public String schemaType() {
        return TYPE;
    }

    @Override
    public String name() {
        if (this.schemaObj != null && this.schemaObj.getType() == Schema.Type.RECORD) {
            return this.schemaObj.getFullName();
        }
        return null;
    }

    @Override
    public String canonicalString() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.canonicalString == null) {
            Schema.Parser parser = this.getParser();
            ArrayList<Schema> schemaRefs = new ArrayList<Schema>();
            for (String schema : this.resolvedReferences.values()) {
                Schema schemaRef = parser.parse(schema);
                schemaRefs.add(schemaRef);
            }
            this.canonicalString = Schemas.toString(this.schemaObj, schemaRefs);
        }
        return this.canonicalString;
    }

    public Integer version() {
        return this.version;
    }

    @Override
    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.resolvedReferences;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public List<String> isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return Collections.singletonList("Incompatible because of different schema type");
        }
        try {
            BACKWARD_VALIDATOR.validate(this.schemaObj, Collections.singleton(((AvroSchema)previousSchema).schemaObj));
            return Collections.emptyList();
        }
        catch (SchemaValidationException e) {
            return Collections.singletonList(e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected exception during compatibility check", (Throwable)e);
            return Collections.singletonList("Unexpected exception during compatibility check: " + e.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroSchema that = (AvroSchema)o;
        return Objects.equals(this.schemaObj, that.schemaObj) && Objects.equals(this.references, that.references) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.schemaObj, this.references, this.version);
    }

    public String toString() {
        return this.canonicalString();
    }
}

