/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.basicauth;

import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class BasicAuthCredentialProviderFactory {
    static final Map<String, BasicAuthCredentialProvider> basicAuthCredentialProviderMap = new HashMap<String, BasicAuthCredentialProvider>();

    public static BasicAuthCredentialProvider getBasicAuthCredentialProvider(String basicAuthCredentialSource, Map<String, ?> configs) {
        BasicAuthCredentialProvider basicAuthCredentialProvider = basicAuthCredentialProviderMap.get(basicAuthCredentialSource);
        if (basicAuthCredentialProvider != null) {
            basicAuthCredentialProvider.configure(configs);
        }
        return basicAuthCredentialProvider;
    }

    static {
        ServiceLoader<BasicAuthCredentialProvider> serviceLoader = ServiceLoader.load(BasicAuthCredentialProvider.class, BasicAuthCredentialProviderFactory.class.getClassLoader());
        for (BasicAuthCredentialProvider basicAuthCredentialProvider : serviceLoader) {
            basicAuthCredentialProviderMap.put(basicAuthCredentialProvider.alias(), basicAuthCredentialProvider);
        }
    }
}

