/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.schema;

import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class ConnectUnion {
    public static final String LOGICAL_PARAMETER = "org.apache.kafka.connect.data.Union";

    public static SchemaBuilder builder(String annotation) {
        return SchemaBuilder.struct().parameter(LOGICAL_PARAMETER, annotation);
    }

    public static boolean isUnion(Schema schema) {
        return schema != null && schema.parameters() != null && schema.parameters().containsKey(LOGICAL_PARAMETER);
    }

    public static Object fromLogical(Schema schema, Struct value) {
        if (!ConnectUnion.isUnion(schema)) {
            throw new DataException("Requested conversion of Union object but the schema does not match.");
        }
        for (Field field : schema.fields()) {
            Object object = value.get(field);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static Struct toLogical(Schema schema, Object value) {
        if (!ConnectUnion.isUnion(schema)) {
            throw new DataException("Requested conversion of Union object but the schema does not match.");
        }
        Struct struct = new Struct(schema);
        for (Field field : schema.fields()) {
            if (!ConnectUnion.validate(field.schema(), value)) continue;
            struct.put(field, value);
            break;
        }
        return struct;
    }

    private static boolean validate(Schema schema, Object value) {
        try {
            ConnectSchema.validateValue((Schema)schema, (Object)value);
        }
        catch (DataException e) {
            return false;
        }
        return true;
    }

    public static Struct toLogicalUsingName(Schema schema, String fieldName, Object value) {
        if (!ConnectUnion.isUnion(schema)) {
            throw new DataException("Requested conversion of Union object but the schema does not match.");
        }
        Struct struct = new Struct(schema);
        for (Field field : schema.fields()) {
            if (!field.name().equals(fieldName)) continue;
            struct.put(field, value);
            break;
        }
        return struct;
    }
}

