/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.RecordMetadataOrException;
import io.confluent.kafkarest.Utils;
import io.confluent.kafkarest.entities.AvroTopicProduceRecord;
import io.confluent.kafkarest.entities.BinaryTopicProduceRecord;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.JsonTopicProduceRecord;
import io.confluent.kafkarest.entities.PartitionOffset;
import io.confluent.kafkarest.entities.ProduceResponse;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.kafkarest.entities.TopicProduceRecord;
import io.confluent.kafkarest.entities.TopicProduceRequest;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/topics")
@Produces(value={"application/vnd.kafka.v1+json; qs=0.9", "application/vnd.kafka+json; qs=0.8", "application/json; qs=0.5", "application/vnd.kafka.v2+json; qs=0.9"})
@Consumes(value={"application/vnd.kafka.v1+json", "application/vnd.kafka+json", "application/json", "application/octet-stream", "application/vnd.kafka.v2+json"})
public class TopicsResource {
    private static final Logger log = LoggerFactory.getLogger(TopicsResource.class);
    private final KafkaRestContext ctx;

    public TopicsResource(KafkaRestContext ctx) {
        this.ctx = ctx;
    }

    @GET
    @PerformanceMetric(value="topics.list")
    public Collection<String> list() throws Exception {
        return this.ctx.getAdminClientWrapper().getTopicNames();
    }

    @GET
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.get")
    public Topic getTopic(@PathParam(value="topic") String topicName) throws Exception {
        Topic topic = this.ctx.getAdminClientWrapper().getTopic(topicName);
        if (topic == null) {
            throw Errors.topicNotFoundException();
        }
        return topic;
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-binary")
    @Consumes(value={"application/vnd.kafka.binary.v1+json", "application/vnd.kafka.v1+json", "application/vnd.kafka+json", "application/json", "application/octet-stream", "application/vnd.kafka.binary.v2+json", "application/vnd.kafka.v2+json"})
    public void produceBinary(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @Valid @NotNull TopicProduceRequest<BinaryTopicProduceRecord> request) {
        this.produce(asyncResponse, topicName, EmbeddedFormat.BINARY, request);
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-json")
    @Consumes(value={"application/vnd.kafka.json.v1+json", "application/vnd.kafka.json.v2+json"})
    public void produceJson(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @Valid @NotNull TopicProduceRequest<JsonTopicProduceRecord> request) {
        this.produce(asyncResponse, topicName, EmbeddedFormat.JSON, request);
    }

    @POST
    @Path(value="/{topic}")
    @PerformanceMetric(value="topic.produce-avro")
    @Consumes(value={"application/vnd.kafka.avro.v1+json", "application/vnd.kafka.avro.v2+json"})
    public void produceAvro(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @Valid @NotNull TopicProduceRequest<AvroTopicProduceRecord> request) {
        boolean hasKeys = false;
        boolean hasValues = false;
        for (AvroTopicProduceRecord rec : request.getRecords()) {
            hasKeys = hasKeys || !rec.getJsonKey().isNull();
            hasValues = hasValues || !rec.getJsonValue().isNull();
        }
        if (hasKeys && request.getKeySchema() == null && request.getKeySchemaId() == null) {
            throw Errors.keySchemaMissingException();
        }
        if (hasValues && request.getValueSchema() == null && request.getValueSchemaId() == null) {
            throw Errors.valueSchemaMissingException();
        }
        this.produce(asyncResponse, topicName, EmbeddedFormat.AVRO, request);
    }

    public <K, V, R extends TopicProduceRecord<K, V>> void produce(final AsyncResponse asyncResponse, String topicName, EmbeddedFormat format, TopicProduceRequest<R> request) {
        log.trace("Executing topic produce request id={} topic={} format={} request={}", new Object[]{asyncResponse, topicName, format, request});
        this.ctx.getProducerPool().produce(topicName, null, format, request, request.getRecords(), new ProducerPool.ProduceRequestCallback(){

            @Override
            public void onCompletion(Integer keySchemaId, Integer valueSchemaId, List<RecordMetadataOrException> results) {
                ProduceResponse response = new ProduceResponse();
                Vector<PartitionOffset> offsets = new Vector<PartitionOffset>();
                for (RecordMetadataOrException result : results) {
                    if (result.getException() != null) {
                        int errorCode = Utils.errorCodeFromProducerException(result.getException());
                        String errorMessage = result.getException().getMessage();
                        offsets.add(new PartitionOffset(null, null, errorCode, errorMessage));
                        continue;
                    }
                    offsets.add(new PartitionOffset(result.getRecordMetadata().partition(), result.getRecordMetadata().offset(), null, null));
                }
                response.setOffsets(offsets);
                response.setKeySchemaId(keySchemaId);
                response.setValueSchemaId(valueSchemaId);
                log.trace("Completed topic produce request id={} response={}", (Object)asyncResponse, (Object)response);
                Response.Status requestStatus = Utils.produceRequestStatus(response);
                asyncResponse.resume((Object)Response.status((Response.Status)requestStatus).entity((Object)response).build());
            }
        });
    }
}

