/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources;

import io.confluent.kafkarest.ConsumerReadCallback;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.RecordMetadataOrException;
import io.confluent.kafkarest.Utils;
import io.confluent.kafkarest.entities.AvroProduceRecord;
import io.confluent.kafkarest.entities.BinaryProduceRecord;
import io.confluent.kafkarest.entities.ConsumerRecord;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.JsonProduceRecord;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.PartitionOffset;
import io.confluent.kafkarest.entities.PartitionProduceRequest;
import io.confluent.kafkarest.entities.ProduceRecord;
import io.confluent.kafkarest.entities.ProduceResponse;
import io.confluent.rest.annotations.PerformanceMetric;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/topics/{topic}/partitions")
@Produces(value={"application/vnd.kafka.binary.v1+json; qs=0.1", "application/vnd.kafka.avro.v1+json; qs=0.1", "application/vnd.kafka.v1+json; qs=0.9", "application/vnd.kafka+json; qs=0.8", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.kafka.v1+json", "application/vnd.kafka+json", "application/json", "application/octet-stream"})
public class PartitionsResource {
    private static final Logger log = LoggerFactory.getLogger(PartitionsResource.class);
    private final KafkaRestContext ctx;

    public PartitionsResource(KafkaRestContext ctx) {
        this.ctx = ctx;
    }

    @GET
    @PerformanceMetric(value="partitions.list")
    public List<Partition> list(@PathParam(value="topic") String topic) throws Exception {
        this.checkTopicExists(topic);
        return this.ctx.getAdminClientWrapper().getTopicPartitions(topic);
    }

    @GET
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.get")
    public Partition getPartition(@PathParam(value="topic") String topic, @PathParam(value="partition") int partition) throws Exception {
        this.checkTopicExists(topic);
        Partition part = this.ctx.getAdminClientWrapper().getTopicPartition(topic, partition);
        if (part == null) {
            throw Errors.partitionNotFoundException();
        }
        return part;
    }

    @GET
    @Path(value="/{partition}/messages")
    @PerformanceMetric(value="partition.consume-binary")
    @Produces(value={"application/vnd.kafka.binary.v1+json", "application/vnd.kafka.v1+json; qs=0.9", "application/vnd.kafka+json; qs=0.8", "application/json; qs=0.5"})
    public void consumeBinary(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @PathParam(value="partition") int partitionId, @QueryParam(value="offset") @Nullable Long offset, @QueryParam(value="timestamp") @Nullable Instant timestamp, @QueryParam(value="count") @DefaultValue(value="1") long count) {
        if (offset != null == (timestamp != null)) {
            throw new BadRequestException("Either `offset` or `timestamp` query parameters must be set.");
        }
        if (offset != null) {
            this.consume(asyncResponse, topicName, partitionId, offset, count, EmbeddedFormat.BINARY);
        } else {
            this.consume(asyncResponse, topicName, partitionId, timestamp, count, EmbeddedFormat.BINARY);
        }
    }

    @GET
    @Path(value="/{partition}/messages")
    @PerformanceMetric(value="partition.consume-avro")
    @Produces(value={"application/vnd.kafka.avro.v1+json; qs=0.1"})
    public void consumeAvro(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @PathParam(value="partition") int partitionId, @QueryParam(value="offset") @Nullable Long offset, @QueryParam(value="timestamp") @Nullable Instant timestamp, @QueryParam(value="count") @DefaultValue(value="1") long count) {
        if (offset != null == (timestamp != null)) {
            throw new BadRequestException("Either `offset` or `timestamp` query parameters must be set.");
        }
        if (offset != null) {
            this.consume(asyncResponse, topicName, partitionId, offset, count, EmbeddedFormat.AVRO);
        } else {
            this.consume(asyncResponse, topicName, partitionId, timestamp, count, EmbeddedFormat.AVRO);
        }
    }

    @GET
    @Path(value="/{partition}/messages")
    @PerformanceMetric(value="partition.consume-json")
    @Produces(value={"application/vnd.kafka.json.v1+json; qs=0.1"})
    public void consumeJson(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @PathParam(value="partition") int partitionId, @QueryParam(value="offset") @Nullable Long offset, @QueryParam(value="timestamp") @Nullable Instant timestamp, @QueryParam(value="count") @DefaultValue(value="1") long count) {
        if (offset != null == (timestamp != null)) {
            throw new BadRequestException("Either `offset` or `timestamp` query parameters must be set.");
        }
        if (offset != null) {
            this.consume(asyncResponse, topicName, partitionId, offset, count, EmbeddedFormat.JSON);
        } else {
            this.consume(asyncResponse, topicName, partitionId, timestamp, count, EmbeddedFormat.JSON);
        }
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-binary")
    @Consumes(value={"application/vnd.kafka.binary.v1+json", "application/vnd.kafka.v1+json", "application/vnd.kafka+json", "application/json", "application/octet-stream"})
    public void produceBinary(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic, @PathParam(value="partition") int partition, @Valid @NotNull PartitionProduceRequest<BinaryProduceRecord> request) {
        this.produce(asyncResponse, topic, partition, EmbeddedFormat.BINARY, request);
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-json")
    @Consumes(value={"application/vnd.kafka.json.v1+json"})
    public void produceJson(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic, @PathParam(value="partition") int partition, @Valid @NotNull PartitionProduceRequest<JsonProduceRecord> request) {
        this.produce(asyncResponse, topic, partition, EmbeddedFormat.JSON, request);
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-avro")
    @Consumes(value={"application/vnd.kafka.avro.v1+json"})
    public void produceAvro(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topic, @PathParam(value="partition") int partition, @Valid @NotNull PartitionProduceRequest<AvroProduceRecord> request) {
        boolean hasKeys = false;
        boolean hasValues = false;
        for (AvroProduceRecord rec : request.getRecords()) {
            hasKeys = hasKeys || !rec.getJsonKey().isNull();
            hasValues = hasValues || !rec.getJsonValue().isNull();
        }
        if (hasKeys && request.getKeySchema() == null && request.getKeySchemaId() == null) {
            throw Errors.keySchemaMissingException();
        }
        if (hasValues && request.getValueSchema() == null && request.getValueSchemaId() == null) {
            throw Errors.valueSchemaMissingException();
        }
        this.produce(asyncResponse, topic, partition, EmbeddedFormat.AVRO, request);
    }

    private void consume(@Suspended AsyncResponse asyncResponse, String topicName, int partitionId, Instant timestamp, long count, EmbeddedFormat embeddedFormat) {
        Optional<Long> offset = this.ctx.getKafkaConsumerManager().getOffsetForTime(topicName, partitionId, timestamp);
        if (offset.isPresent()) {
            this.consume(asyncResponse, topicName, partitionId, offset.get(), count, embeddedFormat);
        } else {
            asyncResponse.resume(Collections.emptyList());
        }
    }

    private <K, V> void consume(final @Suspended AsyncResponse asyncResponse, String topicName, int partitionId, long offset, long count, EmbeddedFormat embeddedFormat) {
        log.trace("Executing simple consume id={} topic={} partition={} offset={} count={}", new Object[]{asyncResponse, topicName, partitionId, offset, count});
        this.ctx.getSimpleConsumerManager().consume(topicName, partitionId, offset, count, embeddedFormat, new ConsumerReadCallback<K, V>(){

            public void onCompletion(List<? extends ConsumerRecord<K, V>> records, Exception e) {
                log.trace("Completed simple consume id={} records={} exception={}", new Object[]{asyncResponse, records, e});
                if (e != null) {
                    asyncResponse.resume((Throwable)e);
                } else {
                    asyncResponse.resume(records);
                }
            }
        });
    }

    protected <K, V, R extends ProduceRecord<K, V>> void produce(final AsyncResponse asyncResponse, String topic, int partition, EmbeddedFormat format, PartitionProduceRequest<R> request) {
        log.trace("Executing topic produce request id={} topic={} partition={} format={} request={}", new Object[]{asyncResponse, topic, partition, format, request});
        this.ctx.getProducerPool().produce(topic, partition, format, request, request.getRecords(), new ProducerPool.ProduceRequestCallback(){

            @Override
            public void onCompletion(Integer keySchemaId, Integer valueSchemaId, List<RecordMetadataOrException> results) {
                ProduceResponse response = new ProduceResponse();
                Vector<PartitionOffset> offsets = new Vector<PartitionOffset>();
                for (RecordMetadataOrException result : results) {
                    if (result.getException() != null) {
                        int errorCode = Utils.errorCodeFromProducerException(result.getException());
                        String errorMessage = result.getException().getMessage();
                        offsets.add(new PartitionOffset(null, null, errorCode, errorMessage));
                        continue;
                    }
                    offsets.add(new PartitionOffset(result.getRecordMetadata().partition(), result.getRecordMetadata().offset(), null, null));
                }
                response.setOffsets(offsets);
                response.setKeySchemaId(keySchemaId);
                response.setValueSchemaId(valueSchemaId);
                log.trace("Completed topic produce request id={} response={}", (Object)asyncResponse, (Object)response);
                Response.Status requestStatus = Utils.produceRequestStatus(response);
                asyncResponse.resume((Object)Response.status((Response.Status)requestStatus).entity((Object)response).build());
            }
        });
    }

    private boolean topicExists(String topic) throws Exception {
        return this.ctx.getAdminClientWrapper().topicExists(topic);
    }

    private void checkTopicExists(String topic) throws Exception {
        if (!this.topicExists(topic)) {
            throw Errors.topicNotFoundException();
        }
    }
}

