/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

public class TopicPartitionOffsetMetadata {
    @NotEmpty
    private String topic;
    @Min(value=0L)
    private @Min(value=0L) int partition;
    @Min(value=0L)
    private @Min(value=0L) long offset;
    private String metadata;

    public TopicPartitionOffsetMetadata(@JsonProperty(value="topic") String topic, @JsonProperty(value="partition") int partition, @JsonProperty(value="offset") long offset, @JsonProperty(value="metadata") String metadata) {
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.metadata = metadata;
    }

    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public void setPartition(int partition) {
        this.partition = partition;
    }

    @JsonProperty
    public long getOffset() {
        return this.offset;
    }

    @JsonProperty
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @JsonProperty
    public String getMetadata() {
        return this.metadata;
    }

    @JsonProperty
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionOffsetMetadata that = (TopicPartitionOffsetMetadata)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (this.partition != that.partition) {
            return false;
        }
        return !(this.topic != null ? !this.topic.equals(that.topic) : that.topic != null);
    }

    public int hashCode() {
        int result = this.topic != null ? this.topic.hashCode() : 0;
        result = 31 * result + this.partition;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }
}

