/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.entities.PartitionOffset;
import io.confluent.kafkarest.entities.ProduceResponse;
import io.confluent.rest.exceptions.RestServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.RetriableException;

public class Utils {
    public static final String UNEXPECTED_PRODUCER_EXCEPTION = "Unexpected non-Kafka exception returned by Kafka";

    public static int errorCodeFromProducerException(Throwable e) {
        if (e instanceof AuthenticationException) {
            return 40101;
        }
        if (e instanceof AuthorizationException) {
            return 40301;
        }
        if (e instanceof RetriableException) {
            return 50003;
        }
        if (e instanceof KafkaException) {
            return 50002;
        }
        throw new RestServerErrorException(UNEXPECTED_PRODUCER_EXCEPTION, RestServerErrorException.DEFAULT_ERROR_CODE, e);
    }

    public static Response.Status produceRequestStatus(ProduceResponse response) {
        for (PartitionOffset partitionOffset : response.getOffsets()) {
            if (partitionOffset.getErrorCode() == null) continue;
            if (partitionOffset.getErrorCode() == 40101) {
                return Response.Status.UNAUTHORIZED;
            }
            if (partitionOffset.getErrorCode() != 40301) continue;
            return Response.Status.FORBIDDEN;
        }
        return Response.Status.OK;
    }
}

