/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.KafkaRestConfig;
import java.util.List;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.eclipse.jetty.util.StringUtil;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class RestConfigUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bootstrapBrokers(KafkaRestConfig config) {
        int zkSessionTimeoutMs = config.getInt("client.zk.session.timeout.ms");
        String bootstrapServersConfig = config.getString("bootstrap.servers");
        if (StringUtil.isNotBlank((String)bootstrapServersConfig)) {
            return bootstrapServersConfig;
        }
        try (KafkaZkClient zkClient = null;){
            Time time = Time.SYSTEM;
            zkClient = new KafkaZkClient(new ZooKeeperClient(config.getString("zookeeper.connect"), zkSessionTimeoutMs, zkSessionTimeoutMs, Integer.MAX_VALUE, time, "testMetricGroup", "testMetricGroupType"), JaasUtils.isZkSecurityEnabled(), time);
            String string = RestConfigUtils.getBootstrapBrokers(zkClient);
            return string;
        }
    }

    private static String getBootstrapBrokers(KafkaZkClient zkClient) {
        Seq brokerSeq = zkClient.getAllBrokersInCluster();
        List brokers = JavaConversions.seqAsJavaList((Seq)brokerSeq);
        String bootstrapBrokers = "";
        for (int i = 0; i < brokers.size(); ++i) {
            for (EndPoint ep : JavaConversions.asJavaCollection((Iterable)((Broker)brokers.get(i)).endPoints())) {
                if (bootstrapBrokers.length() > 0) {
                    bootstrapBrokers = bootstrapBrokers + ",";
                }
                String hostport = ep.host() == null ? ":" + ep.port() : Utils.formatAddress((String)ep.host(), (Integer)ep.port());
                bootstrapBrokers = bootstrapBrokers + ep.securityProtocol() + "://" + hostport;
            }
        }
        return bootstrapBrokers;
    }
}

