/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.RecordMetadataOrException;
import io.confluent.kafkarest.entities.SchemaHolder;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduceTask {
    private static final Logger log = LoggerFactory.getLogger(ProduceTask.class);
    private final SchemaHolder schemaHolder;
    private final int numRecords;
    private final ProducerPool.ProduceRequestCallback callback;
    private int completed;
    private Integer keySchemaId;
    private Integer valueSchemaId;
    private List<RecordMetadataOrException> results;

    public ProduceTask(SchemaHolder schemaHolder, int numRecords, ProducerPool.ProduceRequestCallback callback) {
        this.schemaHolder = schemaHolder;
        this.numRecords = numRecords;
        this.callback = callback;
        this.completed = 0;
        this.results = new ArrayList<RecordMetadataOrException>();
    }

    public synchronized Callback createCallback() {
        final int index = this.results.size();
        this.results.add(null);
        return new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                ProduceTask.this.onCompletion(index, metadata, exception);
            }
        };
    }

    public synchronized void onCompletion(int messageNum, RecordMetadata metadata, Exception exception) {
        this.results.set(messageNum, new RecordMetadataOrException(metadata, exception));
        if (exception != null) {
            log.error("Producer error for request " + this.toString(), (Throwable)exception);
        }
        ++this.completed;
        if (this.completed == this.numRecords) {
            this.callback.onCompletion(this.keySchemaId, this.valueSchemaId, this.results);
        }
    }

    public SchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }

    public void setSchemaIds(Integer keySchemaId, Integer valueSchemaId) {
        this.keySchemaId = keySchemaId;
        this.valueSchemaId = valueSchemaId;
    }
}

