/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.AdminClientWrapper;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.ScalaConsumersContext;
import io.confluent.kafkarest.extension.ContextInvocationHandler;
import io.confluent.kafkarest.extension.InstantConverterProvider;
import io.confluent.kafkarest.extension.KafkaRestCleanupFilter;
import io.confluent.kafkarest.extension.KafkaRestContextProvider;
import io.confluent.kafkarest.extension.RestResourceExtension;
import io.confluent.kafkarest.resources.BrokersResource;
import io.confluent.kafkarest.resources.RootResource;
import io.confluent.kafkarest.resources.TopicsResource;
import io.confluent.kafkarest.resources.v2.ConsumersResource;
import io.confluent.kafkarest.resources.v2.PartitionsResource;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.exceptions.ConstraintViolationExceptionMapper;
import io.confluent.rest.exceptions.KafkaExceptionMapper;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.util.StringUtil;

public class KafkaRestApplication
extends Application<KafkaRestConfig> {
    List<RestResourceExtension> restResourceExtensions;

    public KafkaRestApplication() throws RestConfigException {
        this(new Properties());
    }

    public KafkaRestApplication(Properties props) throws RestConfigException {
        super((RestConfig)new KafkaRestConfig(props));
    }

    public KafkaRestApplication(KafkaRestConfig config) {
        super((RestConfig)config);
        this.restResourceExtensions = config.getConfiguredInstances("kafka.rest.resource.extension.class", RestResourceExtension.class);
    }

    public void setupResources(Configurable<?> config, KafkaRestConfig appConfig) {
        this.setupInjectedResources(config, appConfig, null, null, null, null);
    }

    protected void setupInjectedResources(Configurable<?> config, KafkaRestConfig appConfig, ProducerPool producerPool, KafkaConsumerManager kafkaConsumerManager, AdminClientWrapper adminClientWrapperInjected, ScalaConsumersContext scalaConsumersContext) {
        if (StringUtil.isBlank((String)appConfig.getString("bootstrap.servers")) && StringUtil.isBlank((String)appConfig.getString("zookeeper.connect"))) {
            throw new RuntimeException("Atleast one of bootstrap.servers or zookeeper.connect needs to be configured");
        }
        KafkaRestContextProvider.initialize(config, appConfig, producerPool, kafkaConsumerManager, adminClientWrapperInjected, scalaConsumersContext);
        ContextInvocationHandler contextInvocationHandler = new ContextInvocationHandler();
        KafkaRestContext context = (KafkaRestContext)Proxy.newProxyInstance(KafkaRestContext.class.getClassLoader(), new Class[]{KafkaRestContext.class}, (InvocationHandler)contextInvocationHandler);
        config.register(RootResource.class);
        config.register((Object)new BrokersResource(context));
        config.register((Object)new TopicsResource(context));
        config.register((Object)new io.confluent.kafkarest.resources.PartitionsResource(context));
        config.register((Object)new io.confluent.kafkarest.resources.ConsumersResource(context));
        config.register((Object)new ConsumersResource(context));
        config.register((Object)new PartitionsResource(context));
        config.register(KafkaRestCleanupFilter.class);
        config.register(InstantConverterProvider.class);
        for (RestResourceExtension restResourceExtension : this.restResourceExtensions) {
            restResourceExtension.register(config, appConfig);
        }
    }

    protected void registerExceptionMappers(Configurable<?> config, KafkaRestConfig restConfig) {
        config.register(ConstraintViolationExceptionMapper.class);
        config.register((Object)new WebApplicationExceptionMapper((RestConfig)restConfig));
        config.register((Object)new KafkaExceptionMapper((RestConfig)restConfig));
    }

    public void onShutdown() {
        for (RestResourceExtension restResourceExtension : this.restResourceExtensions) {
            restResourceExtension.clean();
        }
        KafkaRestContextProvider.clean();
    }
}

