/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.AdminClientWrapper;
import io.confluent.kafkarest.ConsumerManager;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.ScalaConsumersContext;
import io.confluent.kafkarest.SimpleConsumerManager;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;

public class DefaultKafkaRestContext
implements KafkaRestContext {
    private final KafkaRestConfig config;
    private final ScalaConsumersContext scalaConsumersContext;
    private ProducerPool producerPool;
    private KafkaConsumerManager kafkaConsumerManager;
    private AdminClientWrapper adminClientWrapper;

    public DefaultKafkaRestContext(KafkaRestConfig config, ProducerPool producerPool, KafkaConsumerManager kafkaConsumerManager, AdminClientWrapper adminClientWrapper, ScalaConsumersContext scalaConsumersContext) {
        this.config = config;
        this.producerPool = producerPool;
        this.kafkaConsumerManager = kafkaConsumerManager;
        this.adminClientWrapper = adminClientWrapper;
        this.scalaConsumersContext = scalaConsumersContext;
    }

    @Override
    public KafkaRestConfig getConfig() {
        return this.config;
    }

    @Override
    public ProducerPool getProducerPool() {
        if (this.producerPool == null) {
            this.producerPool = new ProducerPool(this.config);
        }
        return this.producerPool;
    }

    @Override
    public ScalaConsumersContext getScalaConsumersContext() {
        return this.scalaConsumersContext;
    }

    @Override
    public ConsumerManager getConsumerManager() {
        return this.scalaConsumersContext.getConsumerManager();
    }

    @Override
    public SimpleConsumerManager getSimpleConsumerManager() {
        return this.scalaConsumersContext.getSimpleConsumerManager();
    }

    @Override
    public KafkaConsumerManager getKafkaConsumerManager() {
        if (this.kafkaConsumerManager == null) {
            this.kafkaConsumerManager = new KafkaConsumerManager(this.config);
        }
        return this.kafkaConsumerManager;
    }

    @Override
    public AdminClientWrapper getAdminClientWrapper() {
        if (this.adminClientWrapper == null) {
            this.adminClientWrapper = new AdminClientWrapper(this.config, AdminClient.create((Properties)AdminClientWrapper.adminProperties(this.config)));
        }
        return this.adminClientWrapper;
    }

    @Override
    public void shutdown() {
        if (this.kafkaConsumerManager != null) {
            this.kafkaConsumerManager.shutdown();
        }
        if (this.producerPool != null) {
            this.producerPool.shutdown();
        }
        if (this.adminClientWrapper != null) {
            this.adminClientWrapper.shutdown();
        }
        if (this.scalaConsumersContext != null) {
            this.scalaConsumersContext.shutdown();
        }
    }
}

