/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.serialization;

import io.confluent.org.apache.kafka.common.errors.SerializationException;
import io.confluent.org.apache.kafka.common.serialization.Deserializer;
import java.util.Map;

public class ShortDeserializer
implements Deserializer<Short> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Short deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 2) {
            throw new SerializationException("Size of data received by ShortDeserializer is not 2");
        }
        short value = 0;
        for (byte b : data) {
            value = (short)(value << 8);
            value = (short)(value | b & 0xFF);
        }
        return value;
    }

    @Override
    public void close() {
    }
}

