/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.security.scram;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ScramExtensions {
    private final Map<String, String> extensionMap;

    public ScramExtensions() {
        this(Collections.emptyMap());
    }

    public ScramExtensions(String extensions) {
        this(ScramExtensions.stringToMap(extensions));
    }

    public ScramExtensions(Map<String, String> extensionMap) {
        this.extensionMap = extensionMap;
    }

    public String extensionValue(String name) {
        return this.extensionMap.get(name);
    }

    public Set<String> extensionNames() {
        return this.extensionMap.keySet();
    }

    public boolean tokenAuthenticated() {
        return Boolean.parseBoolean(this.extensionMap.get("tokenauth"));
    }

    public String toString() {
        return ScramExtensions.mapToString(this.extensionMap);
    }

    private static Map<String, String> stringToMap(String extensions) {
        HashMap<String, String> extensionMap = new HashMap<String, String>();
        if (!extensions.isEmpty()) {
            String[] attrvals;
            for (String attrval : attrvals = extensions.split(",")) {
                String[] array = attrval.split("=", 2);
                extensionMap.put(array[0], array[1]);
            }
        }
        return extensionMap;
    }

    private static String mapToString(Map<String, String> extensionMap) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
        return builder.toString();
    }
}

