/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.security.authenticator;

import io.confluent.org.apache.kafka.common.network.Mode;
import io.confluent.org.apache.kafka.common.security.JaasContext;
import io.confluent.org.apache.kafka.common.security.authenticator.AuthCallbackHandler;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServerCallbackHandler
implements AuthCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SaslServerCallbackHandler.class);
    private final JaasContext jaasContext;

    public SaslServerCallbackHandler(JaasContext jaasContext) throws IOException {
        this.jaasContext = jaasContext;
    }

    @Override
    public void configure(Map<String, ?> configs, Mode mode, Subject subject, String saslMechanism) {
    }

    public JaasContext jaasContext() {
        return this.jaasContext;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof RealmCallback) {
                this.handleRealmCallback((RealmCallback)callback);
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        }
    }

    private void handleRealmCallback(RealmCallback rc) {
        LOG.trace("Client supplied realm: {} ", (Object)rc.getDefaultText());
        rc.setText(rc.getDefaultText());
    }

    private void handleAuthorizeCallback(AuthorizeCallback ac) {
        String authenticationID = ac.getAuthenticationID();
        String authorizationID = ac.getAuthorizationID();
        LOG.info("Successfully authenticated client: authenticationID={}; authorizationID={}.", (Object)authenticationID, (Object)authorizationID);
        ac.setAuthorized(true);
        ac.setAuthorizedID(authenticationID);
    }

    @Override
    public void close() {
    }
}

