/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.CommonFields;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.ArrayOf;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.protocol.types.Type;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.utils.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JoinGroupResponse
extends AbstractResponse {
    private static final String GROUP_PROTOCOL_KEY_NAME = "group_protocol";
    private static final String LEADER_ID_KEY_NAME = "leader_id";
    private static final String MEMBERS_KEY_NAME = "members";
    private static final String MEMBER_METADATA_KEY_NAME = "member_metadata";
    private static final Schema JOIN_GROUP_RESPONSE_MEMBER_V0 = new Schema(CommonFields.MEMBER_ID, new Field("member_metadata", Type.BYTES));
    private static final Schema JOIN_GROUP_RESPONSE_V0;
    private static final Schema JOIN_GROUP_RESPONSE_V1;
    private static final Schema JOIN_GROUP_RESPONSE_V2;
    public static final String UNKNOWN_PROTOCOL = "";
    public static final int UNKNOWN_GENERATION_ID = -1;
    public static final String UNKNOWN_MEMBER_ID = "";
    private final int throttleTimeMs;
    private final Errors error;
    private final int generationId;
    private final String groupProtocol;
    private final String memberId;
    private final String leaderId;
    private final Map<String, ByteBuffer> members;

    public static Schema[] schemaVersions() {
        return new Schema[]{JOIN_GROUP_RESPONSE_V0, JOIN_GROUP_RESPONSE_V1, JOIN_GROUP_RESPONSE_V2};
    }

    public JoinGroupResponse(Errors error, int generationId, String groupProtocol, String memberId, String leaderId, Map<String, ByteBuffer> groupMembers) {
        this(0, error, generationId, groupProtocol, memberId, leaderId, groupMembers);
    }

    public JoinGroupResponse(int throttleTimeMs, Errors error, int generationId, String groupProtocol, String memberId, String leaderId, Map<String, ByteBuffer> groupMembers) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.generationId = generationId;
        this.groupProtocol = groupProtocol;
        this.memberId = memberId;
        this.leaderId = leaderId;
        this.members = groupMembers;
    }

    public JoinGroupResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.members = new HashMap<String, ByteBuffer>();
        for (Object memberDataObj : struct.getArray(MEMBERS_KEY_NAME)) {
            Struct memberData = (Struct)memberDataObj;
            String memberId = memberData.get(CommonFields.MEMBER_ID);
            ByteBuffer memberMetadata = memberData.getBytes(MEMBER_METADATA_KEY_NAME);
            this.members.put(memberId, memberMetadata);
        }
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        this.generationId = struct.get(CommonFields.GENERATION_ID);
        this.groupProtocol = struct.getString(GROUP_PROTOCOL_KEY_NAME);
        this.memberId = struct.get(CommonFields.MEMBER_ID);
        this.leaderId = struct.getString(LEADER_ID_KEY_NAME);
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    public int generationId() {
        return this.generationId;
    }

    public String groupProtocol() {
        return this.groupProtocol;
    }

    public String memberId() {
        return this.memberId;
    }

    public String leaderId() {
        return this.leaderId;
    }

    public boolean isLeader() {
        return this.memberId.equals(this.leaderId);
    }

    public Map<String, ByteBuffer> members() {
        return this.members;
    }

    public static JoinGroupResponse parse(ByteBuffer buffer, short version) {
        return new JoinGroupResponse(ApiKeys.JOIN_GROUP.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.JOIN_GROUP.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        struct.set(CommonFields.GENERATION_ID, this.generationId);
        struct.set(GROUP_PROTOCOL_KEY_NAME, (Object)this.groupProtocol);
        struct.set(CommonFields.MEMBER_ID, this.memberId);
        struct.set(LEADER_ID_KEY_NAME, (Object)this.leaderId);
        ArrayList<Struct> memberArray = new ArrayList<Struct>();
        for (Map.Entry<String, ByteBuffer> entries : this.members.entrySet()) {
            Struct memberData = struct.instance(MEMBERS_KEY_NAME);
            memberData.set(CommonFields.MEMBER_ID, entries.getKey());
            memberData.set(MEMBER_METADATA_KEY_NAME, (Object)entries.getValue());
            memberArray.add(memberData);
        }
        struct.set(MEMBERS_KEY_NAME, (Object)memberArray.toArray());
        return struct;
    }

    public String toString() {
        return "JoinGroupResponse(throttleTimeMs=" + this.throttleTimeMs + ", error=" + (Object)((Object)this.error) + ", generationId=" + this.generationId + ", groupProtocol=" + this.groupProtocol + ", memberId=" + this.memberId + ", leaderId=" + this.leaderId + ", members=" + (this.members == null ? "null" : Utils.join(this.members.keySet(), ",")) + ")";
    }

    static {
        JOIN_GROUP_RESPONSE_V1 = JOIN_GROUP_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.GENERATION_ID, new Field(GROUP_PROTOCOL_KEY_NAME, Type.STRING, "The group protocol selected by the coordinator"), new Field(LEADER_ID_KEY_NAME, Type.STRING, "The leader of the group"), CommonFields.MEMBER_ID, new Field(MEMBERS_KEY_NAME, new ArrayOf(JOIN_GROUP_RESPONSE_MEMBER_V0)));
        JOIN_GROUP_RESPONSE_V2 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, CommonFields.GENERATION_ID, new Field(GROUP_PROTOCOL_KEY_NAME, Type.STRING, "The group protocol selected by the coordinator"), new Field(LEADER_ID_KEY_NAME, Type.STRING, "The leader of the group"), CommonFields.MEMBER_ID, new Field(MEMBERS_KEY_NAME, new ArrayOf(JOIN_GROUP_RESPONSE_MEMBER_V0)));
    }
}

