/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.CommonFields;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.ArrayOf;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DeleteGroupsResponse
extends AbstractResponse {
    private static final String GROUP_ERROR_CODES_KEY_NAME = "group_error_codes";
    private static final Schema GROUP_ERROR_CODE = new Schema(CommonFields.GROUP_ID, CommonFields.ERROR_CODE);
    private static final Schema DELETE_GROUPS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("group_error_codes", new ArrayOf(GROUP_ERROR_CODE), "An array of per group error codes."));
    private final Map<String, Errors> errors;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{DELETE_GROUPS_RESPONSE_V0};
    }

    public DeleteGroupsResponse(Map<String, Errors> errors) {
        this(0, errors);
    }

    public DeleteGroupsResponse(int throttleTimeMs, Map<String, Errors> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public DeleteGroupsResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        Object[] groupErrorCodesStructs = struct.getArray(GROUP_ERROR_CODES_KEY_NAME);
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        for (Object groupErrorCodeStructObj : groupErrorCodesStructs) {
            Struct groupErrorCodeStruct = (Struct)groupErrorCodeStructObj;
            String group = groupErrorCodeStruct.get(CommonFields.GROUP_ID);
            Errors error = Errors.forCode(groupErrorCodeStruct.get(CommonFields.ERROR_CODE));
            errors.put(group, error);
        }
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DELETE_GROUPS.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        ArrayList<Struct> groupErrorCodeStructs = new ArrayList<Struct>(this.errors.size());
        for (Map.Entry<String, Errors> groupError : this.errors.entrySet()) {
            Struct groupErrorCodeStruct = struct.instance(GROUP_ERROR_CODES_KEY_NAME);
            groupErrorCodeStruct.set(CommonFields.GROUP_ID, groupError.getKey());
            groupErrorCodeStruct.set(CommonFields.ERROR_CODE, groupError.getValue().code());
            groupErrorCodeStructs.add(groupErrorCodeStruct);
        }
        struct.set(GROUP_ERROR_CODES_KEY_NAME, (Object)groupErrorCodeStructs.toArray());
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<String, Errors> errors() {
        return this.errors;
    }

    public boolean hasError(String group) {
        return this.errors.containsKey(group) && this.errors.get(group) != Errors.NONE;
    }

    public Errors get(String group) {
        return this.errors.get(group);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.errors);
    }

    public static DeleteGroupsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteGroupsResponse(ApiKeys.DELETE_GROUPS.responseSchema(version).read(buffer));
    }
}

